/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.sql.impl.connector.file.Metadata;
import com.hazelcast.jet.sql.impl.connector.file.MetadataResolver;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.MappingField;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

class MetadataResolvers {
    private final Map<Object, MetadataResolver<?>> resolvers;

    MetadataResolvers(MetadataResolver<?> ... resolvers) {
        this.resolvers = Arrays.stream(resolvers).collect(Collectors.toMap(MetadataResolver::supportedFormat, Function.identity()));
    }

    List<MappingField> resolveAndValidateFields(List<MappingField> userFields, Map<String, ?> options) {
        if (options.get("format") == null) {
            throw QueryException.error((String)"Missing 'format' option");
        }
        if (options.get("path") == null) {
            throw QueryException.error((String)"Missing 'path' option");
        }
        List<MappingField> fields = this.findMetadataResolver(options).resolveAndValidateFields(userFields, options);
        if (fields.isEmpty()) {
            throw QueryException.error((String)"The resolved field list is empty");
        }
        return fields;
    }

    Metadata resolveMetadata(List<MappingField> resolvedFields, Map<String, ?> options) {
        return this.findMetadataResolver(options).resolveMetadata(resolvedFields, options);
    }

    private MetadataResolver<?> findMetadataResolver(Map<String, ?> options) {
        Object format = options.get("format");
        MetadataResolver<?> resolver = this.resolvers.get(format);
        if (resolver == null) {
            throw QueryException.error((String)("Unsupported serialization format: " + format));
        }
        return resolver;
    }
}

