/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.impl.aggregate.DistinctSqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

public final class CountSqlAggregations {
    private CountSqlAggregations() {
    }

    public static SqlAggregation from(boolean ignoreNulls, boolean distinct) {
        CountSqlAggregation aggregation = ignoreNulls ? new CountIgnoreNullsSqlAggregation() : new CountSqlAggregation();
        return distinct ? new DistinctSqlAggregation(aggregation) : aggregation;
    }

    @NotThreadSafe
    private static final class CountIgnoreNullsSqlAggregation
    extends CountSqlAggregation {
        private CountIgnoreNullsSqlAggregation() {
        }

        @Override
        public void accumulate(Object value) {
            if (value == null) {
                return;
            }
            super.accumulate(value);
        }
    }

    @NotThreadSafe
    private static class CountSqlAggregation
    implements SqlAggregation {
        private long value;

        private CountSqlAggregation() {
        }

        @Override
        public void accumulate(Object value) {
            ++this.value;
        }

        @Override
        public void combine(SqlAggregation other0) {
            CountSqlAggregation other = (CountSqlAggregation)other0;
            this.value += other.value;
        }

        @Override
        public Object collect() {
            return this.value;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeLong(this.value);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.value = in.readLong();
        }
    }
}

