/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.Lists;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalTableInsert;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalTableSink;
import com.hazelcast.jet.sql.impl.parse.SqlExtendedInsert;
import com.hazelcast.jet.sql.impl.validate.HazelcastResources;
import com.hazelcast.jet.sql.impl.validate.literal.Literal;
import com.hazelcast.jet.sql.impl.validate.literal.LiteralUtils;
import com.hazelcast.jet.sql.impl.validate.operators.json.HazelcastJsonParseFunction;
import com.hazelcast.jet.sql.impl.validate.operators.json.HazelcastJsonValueFunction;
import com.hazelcast.jet.sql.impl.validate.operators.predicate.HazelcastBetweenOperator;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.HazelcastReturnTypeInference;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.avatica.util.TimeUnit;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.runtime.CalciteContextException;
import com.hazelcast.org.apache.calcite.runtime.Resources;
import com.hazelcast.org.apache.calcite.sql.SqlBasicCall;
import com.hazelcast.org.apache.calcite.sql.SqlBinaryOperator;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlInsert;
import com.hazelcast.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.org.apache.calcite.sql.SqlJsonEmptyOrError;
import com.hazelcast.org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import com.hazelcast.org.apache.calcite.sql.SqlJsonValueReturning;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.fun.SqlBetweenOperator;
import com.hazelcast.org.apache.calcite.sql.fun.SqlInOperator;
import com.hazelcast.org.apache.calcite.sql.fun.SqlRowOperator;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorException;
import com.hazelcast.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import com.hazelcast.org.apache.calcite.sql2rel.SqlToRelConverter;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.TimeString;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class HazelcastSqlToRelConverter
extends SqlToRelConverter {
    private static final SqlIntervalQualifier INTERVAL_YEAR_MONTH = new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO);
    private static final SqlIntervalQualifier INTERVAL_DAY_SECOND = new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO);
    private final Set<SqlNode> callSet = Collections.newSetFromMap(new IdentityHashMap());

    public HazelcastSqlToRelConverter(SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, SqlToRelConverter.Config config) {
        super(null, validator, catalogReader, cluster, convertletTable, config);
    }

    @Override
    protected RexNode convertExtendedExpression(SqlNode node, SqlToRelConverter.Blackboard blackboard) {
        if (node.getKind() == SqlKind.LITERAL) {
            return this.convertLiteral((SqlLiteral)node, blackboard.getTypeFactory());
        }
        if (node.getKind() == SqlKind.CAST) {
            return this.convertCast((SqlCall)node, blackboard);
        }
        if (node.getKind() == SqlKind.IN || node.getKind() == SqlKind.NOT_IN) {
            return this.convertIn((SqlCall)node, blackboard);
        }
        if (node.getKind() == SqlKind.BETWEEN) {
            return this.convertBetween((SqlCall)node, blackboard);
        }
        if (node instanceof SqlCall) {
            return this.convertCall(node, blackboard);
        }
        return null;
    }

    private RexNode convertLiteral(SqlLiteral literal, RelDataTypeFactory typeFactory) {
        Object value;
        RelDataType type = this.validator.getValidatedNodeType(literal);
        if (HazelcastTypeUtils.isIntervalType(type) && !SqlUtil.isNullLiteral(literal, false)) {
            value = literal.getValueAs(BigDecimal.class);
            SqlTypeFamily family = type.getSqlTypeName().getFamily();
            if (family == SqlTypeFamily.INTERVAL_YEAR_MONTH) {
                type = typeFactory.createSqlIntervalType(INTERVAL_YEAR_MONTH);
            } else {
                assert (family == SqlTypeFamily.INTERVAL_DAY_TIME);
                type = typeFactory.createSqlIntervalType(INTERVAL_DAY_SECOND);
            }
        } else {
            value = literal.getValue();
        }
        return this.getRexBuilder().makeLiteral(value, type, true);
    }

    private RexNode convertCast(SqlCall call, SqlToRelConverter.Blackboard blackboard) {
        Object operand = call.operand(0);
        RexNode convertedOperand = blackboard.convertExpression((SqlNode)operand);
        RelDataType from = this.validator.getValidatedNodeType((SqlNode)operand);
        RelDataType to = this.validator.getValidatedNodeType(call);
        QueryDataType fromType = HazelcastTypeUtils.toHazelcastType(from);
        QueryDataType toType = HazelcastTypeUtils.toHazelcastType(to);
        Literal literal = LiteralUtils.literal(convertedOperand);
        if (literal != null && !HazelcastTypeUtils.isNullOrUnknown(((RexLiteral)convertedOperand).getTypeName())) {
            try {
                QueryDataType actualFromType = HazelcastTypeUtils.toHazelcastTypeFromSqlTypeName(literal.getTypeName());
                toType.getConverter().convertToSelf(actualFromType.getConverter(), literal.getValue());
            }
            catch (Exception e) {
                throw HazelcastSqlToRelConverter.literalConversionException(this.validator, call, literal, toType, e);
            }
            if (SqlTypeName.CHAR_TYPES.contains((Object)to.getSqlTypeName())) {
                return this.getRexBuilder().makeLiteral(literal.getStringValue(), to, true);
            }
            if (SqlTypeName.CHAR_TYPES.contains((Object)from.getSqlTypeName()) && to.getSqlTypeName() == SqlTypeName.TIME) {
                LocalTime time = fromType.getConverter().asTime((Object)literal.getStringValue());
                TimeString timeString = new TimeString(time.getHour(), time.getMinute(), time.getSecond());
                return this.getRexBuilder().makeLiteral((Object)timeString, to, true);
            }
            if (fromType.getTypeFamily().isNumeric() && toType.getTypeFamily().isNumericApproximate()) {
                Converter converter = Converters.getConverter(literal.getValue().getClass());
                Object convertedValue = toType.getConverter().convertToSelf(converter, literal.getValue());
                return this.getRexBuilder().makeLiteral(convertedValue, to, false);
            }
        }
        if (literal != null && HazelcastTypeUtils.isJsonType(to)) {
            return this.getRexBuilder().makeCall((SqlOperator)HazelcastJsonParseFunction.INSTANCE, convertedOperand);
        }
        return this.getRexBuilder().makeCast(to, convertedOperand);
    }

    private RexNode convertIn(SqlCall call, SqlToRelConverter.Blackboard blackboard) {
        Object rhs;
        AbstractCollection leftKeys;
        assert (call.getOperandList().size() == 2);
        Object lhs = call.operand(0);
        if (((SqlNode)lhs).getKind() == SqlKind.ROW) {
            leftKeys = new ArrayList();
            for (SqlNode sqlExpr : ((SqlBasicCall)lhs).getOperandList()) {
                leftKeys.add(blackboard.convertExpression(sqlExpr));
            }
        } else {
            leftKeys = ImmutableList.of(blackboard.convertExpression((SqlNode)lhs));
        }
        if ((rhs = call.operand(1)) instanceof SqlNodeList) {
            SqlNodeList valueList = (SqlNodeList)rhs;
            return this.convertInToOr(blackboard, (List<RexNode>)((Object)leftKeys), valueList, (SqlInOperator)call.getOperator());
        }
        throw QueryException.error((String)"Sub-queries are not supported for IN operator.");
    }

    public RexNode convertBetween(SqlCall call, SqlToRelConverter.Blackboard blackboard) {
        RexNode res;
        SqlOperator currentOperator = call.getOperator();
        assert (currentOperator instanceof HazelcastBetweenOperator);
        RexBuilder rexBuilder = this.getRexBuilder();
        HazelcastBetweenOperator betweenOp = (HazelcastBetweenOperator)currentOperator;
        List<RexNode> list = HazelcastSqlToRelConverter.convertExpressionList(rexBuilder, blackboard, call.getOperandList(), betweenOp.getOperandTypeChecker().getConsistency());
        RexNode valueOperand = list.get(0);
        RexNode lowerOperand = list.get(1);
        RexNode upperOperand = list.get(2);
        RexNode ge1 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, valueOperand, lowerOperand);
        RexNode le1 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, valueOperand, upperOperand);
        RexNode and1 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, ge1, le1);
        SqlBetweenOperator.Flag symmetric = betweenOp.getFlag();
        switch (symmetric) {
            case ASYMMETRIC: {
                res = and1;
                break;
            }
            case SYMMETRIC: {
                RexNode ge2 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, valueOperand, upperOperand);
                RexNode le2 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, valueOperand, lowerOperand);
                RexNode and2 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, ge2, le2);
                res = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, and1, and2);
                break;
            }
            default: {
                throw Util.unexpected(symmetric);
            }
        }
        if (betweenOp.isNegated()) {
            res = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, res);
        }
        return res;
    }

    /*
     * Loose catch block
     */
    private RexNode convertCall(SqlNode node, SqlToRelConverter.Blackboard blackboard) {
        if (node.getKind() == SqlKind.DEFAULT) {
            return null;
        }
        if (((SqlCall)node).getOperator() instanceof HazelcastJsonValueFunction) {
            return this.convertJsonValueCall((SqlCall)node, blackboard);
        }
        if (this.callSet.add(node)) {
            try {
                RelDataType type = this.validator.getValidatedNodeType(node);
                HazelcastReturnTypeInference.push(type);
                try {
                    RexNode rexNode = blackboard.convertExpression(node);
                    return rexNode;
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof InvocationTargetException && e.getCause().getCause() instanceof QueryException) {
                        throw (QueryException)e.getCause().getCause();
                    }
                    throw e;
                }
                finally {
                    HazelcastReturnTypeInference.pop();
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.callSet.remove(node);
            }
        }
        return null;
    }

    private RexNode convertJsonValueCall(SqlCall call, SqlToRelConverter.Blackboard bb) {
        RexNode target = bb.convertExpression((SqlNode)call.operand(0));
        RexNode path = bb.convertExpression((SqlNode)call.operand(1));
        SqlJsonValueEmptyOrErrorBehavior onError = SqlJsonValueEmptyOrErrorBehavior.NULL;
        SqlJsonValueEmptyOrErrorBehavior onEmpty = SqlJsonValueEmptyOrErrorBehavior.NULL;
        RelDataType returning = this.validator.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
        RexLiteral defaultValueOnError = this.getRexBuilder().makeNullLiteral(this.typeFactory.createSqlType(SqlTypeName.ANY));
        RexLiteral defaultValueOnEmpty = this.getRexBuilder().makeNullLiteral(this.typeFactory.createSqlType(SqlTypeName.ANY));
        int tokenIndex = 2;
        if (call.operandCount() > 2 && this.isJsonValueReturningClause((SqlNode)call.operand(tokenIndex))) {
            returning = this.validator.getValidatedNodeType((SqlNode)call.operand(tokenIndex + 1));
            tokenIndex += 2;
        }
        boolean onEmptyDefined = false;
        boolean onErrorDefined = false;
        while (tokenIndex < call.operandCount()) {
            if (!(call.operand(tokenIndex) instanceof SqlLiteral)) {
                throw QueryException.error((int)1008, (String)"Unsupported JSON_VALUE extended syntax");
            }
            SqlJsonValueEmptyOrErrorBehavior behavior = (SqlJsonValueEmptyOrErrorBehavior)((SqlLiteral)call.operand(tokenIndex)).getValue();
            RexNode defaultExpr = this.getRexBuilder().makeNullLiteral(this.typeFactory.createSqlType(SqlTypeName.ANY));
            if (behavior == null) {
                throw QueryException.error((int)1008, (String)"Failed to extract ON behavior for JSON_VALUE call");
            }
            switch (behavior) {
                case DEFAULT: {
                    defaultExpr = bb.convertExpression((SqlNode)call.operand(tokenIndex + 1));
                    tokenIndex += 2;
                    break;
                }
                case NULL: 
                case ERROR: {
                    ++tokenIndex;
                    break;
                }
                default: {
                    throw QueryException.error((int)1008, (String)"Unsupported JSON_VALUE OnEmptyOrErrorBehavior");
                }
            }
            SqlJsonEmptyOrError onTarget = (SqlJsonEmptyOrError)((SqlLiteral)call.operand(tokenIndex)).getValue();
            if (onTarget == null) {
                throw QueryException.error((int)1008, (String)"Failed to extract ON-behavior target for JSON_VALUE call");
            }
            switch (onTarget) {
                case EMPTY: {
                    if (onEmptyDefined) {
                        throw QueryException.error((int)1008, (String)"Duplicate ON EMPTY clause in JSON_VALUE call");
                    }
                    if (behavior == SqlJsonValueEmptyOrErrorBehavior.DEFAULT) {
                        defaultValueOnEmpty = defaultExpr;
                    }
                    onEmpty = behavior;
                    onEmptyDefined = true;
                    break;
                }
                case ERROR: {
                    if (onErrorDefined) {
                        throw QueryException.error((int)1008, (String)"Duplicate ON ERROR clause in JSON_VALUE call");
                    }
                    if (behavior == SqlJsonValueEmptyOrErrorBehavior.DEFAULT) {
                        defaultValueOnError = defaultExpr;
                    }
                    onError = behavior;
                    onErrorDefined = true;
                    break;
                }
                default: {
                    throw QueryException.error((int)1008, (String)"Unsupported JSON_VALUE EmptyOrErrorBehavior target");
                }
            }
            ++tokenIndex;
        }
        return this.getRexBuilder().makeCall(returning, HazelcastJsonValueFunction.INSTANCE, Arrays.asList(target, path, defaultValueOnEmpty, defaultValueOnError, bb.convertLiteral(onEmpty.symbol(SqlParserPos.ZERO)), bb.convertLiteral(onError.symbol(SqlParserPos.ZERO))));
    }

    private boolean isJsonValueReturningClause(SqlNode node) {
        return node instanceof SqlLiteral && ((SqlLiteral)node).getValue() instanceof SqlJsonValueReturning;
    }

    private static List<RexNode> convertExpressionList(RexBuilder rexBuilder, SqlToRelConverter.Blackboard bb, List<SqlNode> nodes, SqlOperandTypeChecker.Consistency consistency) {
        RelDataType type;
        if (nodes.size() == 1) {
            return Collections.singletonList(bb.convertExpression(nodes.get(0)));
        }
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        for (SqlNode node : nodes) {
            exprs.add(bb.convertExpression(node));
        }
        if (exprs.size() > 1 && (type = HazelcastSqlToRelConverter.consistentType(bb, consistency, RexUtil.types(exprs))) != null) {
            ArrayList<RexNode> oldExpressions = Lists.newArrayList(exprs);
            exprs.clear();
            for (RexNode expr : oldExpressions) {
                exprs.add(rexBuilder.ensureType(type, expr, true));
            }
        }
        return exprs;
    }

    private static RelDataType consistentType(SqlToRelConverter.Blackboard bb, SqlOperandTypeChecker.Consistency consistency, List<RelDataType> types) {
        switch (consistency) {
            case COMPARE: {
                List<RelDataType> nonCharacterTypes = types.stream().filter(type -> type.getFamily() != SqlTypeFamily.CHARACTER).collect(Collectors.toList());
                if (!nonCharacterTypes.isEmpty()) {
                    types = HazelcastSqlToRelConverter.enlargeNumericTypes(bb, types.size(), nonCharacterTypes);
                }
            }
            case LEAST_RESTRICTIVE: {
                return bb.getTypeFactory().leastRestrictive(types);
            }
        }
        return null;
    }

    private static List<RelDataType> enlargeNumericTypes(SqlToRelConverter.Blackboard bb, int typeCount, List<RelDataType> nonCharacterTypes) {
        RelDataTypeFamily family;
        if (nonCharacterTypes.size() < typeCount && (family = nonCharacterTypes.get(0).getFamily()) instanceof SqlTypeFamily) {
            switch ((SqlTypeFamily)family) {
                case INTEGER: 
                case NUMERIC: {
                    nonCharacterTypes.add(bb.getTypeFactory().createSqlType(SqlTypeName.BIGINT));
                    break;
                }
            }
        }
        return nonCharacterTypes;
    }

    private static QueryException literalConversionException(SqlValidator validator, SqlCall call, Literal literal, QueryDataType toType, Exception e) {
        String literalValue = literal.getStringValue();
        if (SqlTypeName.CHAR_TYPES.contains((Object)literal.getTypeName())) {
            literalValue = "'" + literalValue + "'";
        }
        Resources.ExInst<SqlValidatorException> contextError = HazelcastResources.RESOURCES.cannotCastLiteralValue(literalValue, toType.getTypeFamily().getPublicType().toString(), e.getMessage());
        CalciteContextException calciteContextError = validator.newValidationError(call, contextError);
        throw QueryException.error((int)1008, (String)calciteContextError.getMessage(), (Throwable)e);
    }

    private RexNode convertInToOr(SqlToRelConverter.Blackboard bb, List<RexNode> leftKeys, SqlNodeList valuesList, SqlInOperator op) {
        List<RexNode> comparisons = this.constructComparisons(bb, leftKeys, valuesList);
        switch (op.kind) {
            case ALL: {
                return RexUtil.composeConjunction(this.rexBuilder, comparisons, true);
            }
            case NOT_IN: {
                return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, RexUtil.composeDisjunction(this.rexBuilder, comparisons, true));
            }
            case IN: 
            case SOME: {
                return RexUtil.composeDisjunction(this.rexBuilder, comparisons, true);
            }
        }
        throw new AssertionError();
    }

    private List<RexNode> constructComparisons(SqlToRelConverter.Blackboard bb, List<RexNode> leftKeys, SqlNodeList valuesList) {
        ArrayList<RexNode> comparisons = new ArrayList<RexNode>();
        for (SqlNode rightValues : valuesList) {
            RexNode rexComparison;
            SqlBinaryOperator comparisonOp = SqlStdOperatorTable.EQUALS;
            if (leftKeys.size() == 1) {
                rexComparison = this.rexBuilder.makeCall((SqlOperator)comparisonOp, leftKeys.get(0), this.ensureSqlType(leftKeys.get(0).getType(), bb.convertExpression(rightValues)));
            } else {
                assert (rightValues instanceof SqlCall);
                SqlBasicCall basicCall = (SqlBasicCall)rightValues;
                assert (basicCall.getOperator() instanceof SqlRowOperator && basicCall.operandCount() == leftKeys.size());
                rexComparison = RexUtil.composeConjunction(this.rexBuilder, Pair.zip(leftKeys, basicCall.getOperandList()).stream().map(pair -> this.rexBuilder.makeCall(comparisonOp, (RexNode)pair.left, this.ensureSqlType(((RexNode)pair.left).getType(), bb.convertExpression((SqlNode)pair.right)))).collect(Collectors.toList()));
            }
            comparisons.add(rexComparison);
        }
        return comparisons;
    }

    private RexNode ensureSqlType(RelDataType type, RexNode node) {
        if (type.getSqlTypeName() == node.getType().getSqlTypeName() || type.getSqlTypeName() == SqlTypeName.VARCHAR && node.getType().getSqlTypeName() == SqlTypeName.CHAR) {
            return node;
        }
        return this.rexBuilder.ensureType(type, node, true);
    }

    @Override
    protected RelNode convertInsert(SqlInsert insert0) {
        SqlExtendedInsert insert = (SqlExtendedInsert)insert0;
        TableModify modify = (TableModify)super.convertInsert(insert);
        return insert.isInsert() ? new LogicalTableInsert(modify) : new LogicalTableSink(modify);
    }
}

