/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.jet.sql.impl.validate.types.HazelcastIntegerType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;

public final class HazelcastRexBuilder
extends RexBuilder {
    public static final HazelcastRexBuilder INSTANCE = new HazelcastRexBuilder();

    private HazelcastRexBuilder() {
        super(HazelcastTypeFactory.INSTANCE);
    }

    @Override
    public RexNode makeLiteral(Object value, RelDataType type, boolean allowCast) {
        Converter converter;
        if (type.getSqlTypeName() == SqlTypeName.ANY && value instanceof Number && (converter = Converters.getConverter(value.getClass())) != null) {
            QueryDataTypeFamily typeFamily = converter.getTypeFamily();
            if (typeFamily.isNumericInteger()) {
                int bitWidth = HazelcastIntegerType.bitWidthOf(((Number)value).longValue());
                type = HazelcastIntegerType.create(bitWidth, false);
            } else {
                SqlTypeName typeName = HazelcastTypeUtils.toCalciteType(typeFamily);
                type = HazelcastTypeFactory.INSTANCE.createSqlType(typeName);
            }
        }
        return super.makeLiteral(value, type, allowCast);
    }
}

