/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.esri.core.geometry.ogc;

import com.hazelcast.com.esri.core.geometry.MultiPath;
import com.hazelcast.com.esri.core.geometry.SpatialReference;
import com.hazelcast.com.esri.core.geometry.ogc.OGCGeometry;
import com.hazelcast.com.esri.core.geometry.ogc.OGCLineString;
import com.hazelcast.com.esri.core.geometry.ogc.OGCPoint;

public class OGCLinearRing
extends OGCLineString {
    public OGCLinearRing(MultiPath mp, int pathIndex, SpatialReference sr, boolean reversed) {
        super(mp, pathIndex, sr, reversed);
        if (!mp.isClosedPath(0)) {
            throw new IllegalArgumentException("LinearRing path must be closed");
        }
    }

    @Override
    public int numPoints() {
        if (this.multiPath.isEmpty()) {
            return 0;
        }
        return this.multiPath.getPointCount() + 1;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public boolean isRing() {
        return true;
    }

    @Override
    public OGCPoint pointN(int n) {
        int nn = n == this.multiPath.getPathSize(0) ? this.multiPath.getPathStart(0) : this.multiPath.getPathStart(0) + n;
        return (OGCPoint)OGCGeometry.createFromEsriGeometry(this.multiPath.getPoint(nn), this.esriSR);
    }
}

