/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.esri.core.geometry;

import com.hazelcast.com.esri.core.geometry.AttributeStreamOfDbl;
import com.hazelcast.com.esri.core.geometry.AttributeStreamOfInt32;
import com.hazelcast.com.esri.core.geometry.AttributeStreamOfInt8;
import com.hazelcast.com.esri.core.geometry.Envelope;
import com.hazelcast.com.esri.core.geometry.Envelope1D;
import com.hazelcast.com.esri.core.geometry.Geometry;
import com.hazelcast.com.esri.core.geometry.GeometryCursor;
import com.hazelcast.com.esri.core.geometry.GeometryException;
import com.hazelcast.com.esri.core.geometry.JsonCursor;
import com.hazelcast.com.esri.core.geometry.JsonStringWriter;
import com.hazelcast.com.esri.core.geometry.JsonWriter;
import com.hazelcast.com.esri.core.geometry.MultiPathImpl;
import com.hazelcast.com.esri.core.geometry.MultiPoint;
import com.hazelcast.com.esri.core.geometry.MultiPointImpl;
import com.hazelcast.com.esri.core.geometry.NumberUtils;
import com.hazelcast.com.esri.core.geometry.Point;
import com.hazelcast.com.esri.core.geometry.Polygon;
import com.hazelcast.com.esri.core.geometry.Polyline;
import com.hazelcast.com.esri.core.geometry.SpatialReference;
import com.hazelcast.com.esri.core.geometry.SpatialReferenceImpl;
import com.hazelcast.com.esri.core.geometry.VertexDescription;

class OperatorExportToGeoJsonCursor
extends JsonCursor {
    GeometryCursor m_inputGeometryCursor;
    SpatialReference m_spatialReference;
    int m_index = -1;
    int m_export_flags;

    public OperatorExportToGeoJsonCursor(int export_flags, SpatialReference spatialReference, GeometryCursor geometryCursor) {
        if (geometryCursor == null) {
            throw new IllegalArgumentException();
        }
        this.m_export_flags = export_flags;
        this.m_spatialReference = spatialReference;
        this.m_inputGeometryCursor = geometryCursor;
    }

    @Override
    public int getID() {
        return this.m_index;
    }

    @Override
    public String next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            return OperatorExportToGeoJsonCursor.exportToGeoJson(this.m_export_flags, geometry, this.m_spatialReference);
        }
        return null;
    }

    static String exportToGeoJson(int export_flags, Geometry geometry, SpatialReference spatial_reference) {
        if (geometry == null) {
            throw new IllegalArgumentException("");
        }
        JsonStringWriter json_writer = new JsonStringWriter();
        ((JsonWriter)json_writer).startObject();
        OperatorExportToGeoJsonCursor.exportGeometryToGeoJson_(export_flags, geometry, json_writer);
        if ((export_flags & 8) == 0) {
            ((JsonWriter)json_writer).addFieldName("crs");
            OperatorExportToGeoJsonCursor.exportSpatialReference(export_flags, spatial_reference, json_writer);
        }
        ((JsonWriter)json_writer).endObject();
        return (String)((JsonWriter)json_writer).getJson();
    }

    static String exportSpatialReference(int export_flags, SpatialReference spatial_reference) {
        if (spatial_reference == null || (export_flags & 8) != 0) {
            throw new IllegalArgumentException("");
        }
        JsonStringWriter json_writer = new JsonStringWriter();
        OperatorExportToGeoJsonCursor.exportSpatialReference(export_flags, spatial_reference, json_writer);
        return (String)((JsonWriter)json_writer).getJson();
    }

    private static void exportGeometryToGeoJson_(int export_flags, Geometry geometry, JsonWriter json_writer) {
        int type = geometry.getType().value();
        switch (type) {
            case 1736: {
                OperatorExportToGeoJsonCursor.exportPolygonToGeoJson_(export_flags, (Polygon)geometry, json_writer);
                return;
            }
            case 1607: {
                OperatorExportToGeoJsonCursor.exportPolylineToGeoJson_(export_flags, (Polyline)geometry, json_writer);
                return;
            }
            case 550: {
                OperatorExportToGeoJsonCursor.exportMultiPointToGeoJson_(export_flags, (MultiPoint)geometry, json_writer);
                return;
            }
            case 33: {
                OperatorExportToGeoJsonCursor.exportPointToGeoJson_(export_flags, (Point)geometry, json_writer);
                return;
            }
            case 197: {
                OperatorExportToGeoJsonCursor.exportEnvelopeToGeoJson_(export_flags, (Envelope)geometry, json_writer);
                return;
            }
        }
        throw new RuntimeException("not implemented for this geometry type");
    }

    private static void exportSpatialReference(int export_flags, SpatialReference spatial_reference, JsonWriter json_writer) {
        if (spatial_reference != null) {
            int wkid = spatial_reference.getLatestID();
            if (wkid <= 0) {
                throw new GeometryException("invalid call");
            }
            json_writer.startObject();
            json_writer.addFieldName("type");
            json_writer.addValueString("name");
            json_writer.addFieldName("properties");
            json_writer.startObject();
            json_writer.addFieldName("name");
            String authority = ((SpatialReferenceImpl)spatial_reference).getAuthority();
            authority = authority.toUpperCase();
            StringBuilder crs_identifier = new StringBuilder(authority);
            crs_identifier.append(':');
            crs_identifier.append(wkid);
            json_writer.addValueString(crs_identifier.toString());
            json_writer.endObject();
            json_writer.endObject();
        } else {
            json_writer.addValueNull();
        }
    }

    private static void exportPolygonToGeoJson_(int export_flags, Polygon polygon, JsonWriter json_writer) {
        boolean b_export_ms;
        int simple;
        MultiPathImpl polygon_impl = (MultiPathImpl)polygon._getImpl();
        if ((export_flags & 0x10) != 0 && (simple = polygon_impl.getIsSimple(0.0)) != 2) {
            throw new GeometryException("corrupted geometry");
        }
        int point_count = polygon.getPointCount();
        int polygon_count = polygon_impl.getOGCPolygonCount();
        if (point_count > 0 && polygon_count == 0) {
            throw new GeometryException("corrupted geometry");
        }
        int precision = 17 - (0x1F & export_flags >> 13);
        boolean bFixedPoint = (0x40000 & export_flags) != 0;
        boolean b_export_zs = polygon_impl.hasAttribute(1) && (export_flags & 2) == 0;
        boolean bl = b_export_ms = polygon_impl.hasAttribute(2) && (export_flags & 4) == 0;
        if (!b_export_zs && b_export_ms) {
            throw new IllegalArgumentException("invalid argument");
        }
        int path_count = 0;
        AttributeStreamOfDbl position = null;
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfInt8 path_flags = null;
        AttributeStreamOfInt32 paths = null;
        if (point_count > 0) {
            position = (AttributeStreamOfDbl)polygon_impl.getAttributeStreamRef(0);
            path_flags = polygon_impl.getPathFlagsStreamRef();
            paths = polygon_impl.getPathStreamRef();
            path_count = polygon_impl.getPathCount();
            if (b_export_zs && polygon_impl._attributeStreamIsAllocated(1)) {
                zs = (AttributeStreamOfDbl)polygon_impl.getAttributeStreamRef(1);
            }
            if (b_export_ms && polygon_impl._attributeStreamIsAllocated(2)) {
                ms = (AttributeStreamOfDbl)polygon_impl.getAttributeStreamRef(2);
            }
        }
        if ((export_flags & 1) == 0 && polygon_count <= 1) {
            OperatorExportToGeoJsonCursor.polygonTaggedText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, paths, path_count, json_writer);
        } else {
            OperatorExportToGeoJsonCursor.multiPolygonTaggedText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, polygon_count, path_count, json_writer);
        }
    }

    private static void exportPolylineToGeoJson_(int export_flags, Polyline polyline, JsonWriter json_writer) {
        boolean b_export_ms;
        MultiPathImpl polyline_impl = (MultiPathImpl)polyline._getImpl();
        int point_count = polyline_impl.getPointCount();
        int path_count = polyline_impl.getPathCount();
        if (point_count > 0 && path_count == 0) {
            throw new GeometryException("corrupted geometry");
        }
        int precision = 17 - (0x1F & export_flags >> 13);
        boolean bFixedPoint = (0x40000 & export_flags) != 0;
        boolean b_export_zs = polyline_impl.hasAttribute(1) && (export_flags & 2) == 0;
        boolean bl = b_export_ms = polyline_impl.hasAttribute(2) && (export_flags & 4) == 0;
        if (!b_export_zs && b_export_ms) {
            throw new IllegalArgumentException("invalid argument");
        }
        AttributeStreamOfDbl position = null;
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfInt8 path_flags = null;
        AttributeStreamOfInt32 paths = null;
        if (point_count > 0) {
            position = (AttributeStreamOfDbl)polyline_impl.getAttributeStreamRef(0);
            path_flags = polyline_impl.getPathFlagsStreamRef();
            paths = polyline_impl.getPathStreamRef();
            if (b_export_zs && polyline_impl._attributeStreamIsAllocated(1)) {
                zs = (AttributeStreamOfDbl)polyline_impl.getAttributeStreamRef(1);
            }
            if (b_export_ms && polyline_impl._attributeStreamIsAllocated(2)) {
                ms = (AttributeStreamOfDbl)polyline_impl.getAttributeStreamRef(2);
            }
        }
        if ((export_flags & 1) == 0 && path_count <= 1) {
            OperatorExportToGeoJsonCursor.lineStringTaggedText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, json_writer);
        } else {
            OperatorExportToGeoJsonCursor.multiLineStringTaggedText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, path_count, json_writer);
        }
    }

    private static void exportMultiPointToGeoJson_(int export_flags, MultiPoint multipoint, JsonWriter json_writer) {
        boolean b_export_ms;
        MultiPointImpl multipoint_impl = (MultiPointImpl)multipoint._getImpl();
        int point_count = multipoint_impl.getPointCount();
        int precision = 17 - (0x1F & export_flags >> 13);
        boolean bFixedPoint = (0x40000 & export_flags) != 0;
        boolean b_export_zs = multipoint_impl.hasAttribute(1) && (export_flags & 2) == 0;
        boolean bl = b_export_ms = multipoint_impl.hasAttribute(2) && (export_flags & 4) == 0;
        if (!b_export_zs && b_export_ms) {
            throw new IllegalArgumentException("invalid argument");
        }
        AttributeStreamOfDbl position = null;
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        if (point_count > 0) {
            position = (AttributeStreamOfDbl)multipoint_impl.getAttributeStreamRef(0);
            if (b_export_zs && multipoint_impl._attributeStreamIsAllocated(1)) {
                zs = (AttributeStreamOfDbl)multipoint_impl.getAttributeStreamRef(1);
            }
            if (b_export_ms && multipoint_impl._attributeStreamIsAllocated(2)) {
                ms = (AttributeStreamOfDbl)multipoint_impl.getAttributeStreamRef(2);
            }
        }
        OperatorExportToGeoJsonCursor.multiPointTaggedText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, point_count, json_writer);
    }

    private static void exportPointToGeoJson_(int export_flags, Point point, JsonWriter json_writer) {
        boolean b_export_ms;
        int precision = 17 - (0x1F & export_flags >> 13);
        boolean bFixedPoint = (0x40000 & export_flags) != 0;
        boolean b_export_zs = point.hasAttribute(1) && (export_flags & 2) == 0;
        boolean bl = b_export_ms = point.hasAttribute(2) && (export_flags & 4) == 0;
        if (!b_export_zs && b_export_ms) {
            throw new IllegalArgumentException("invalid argument");
        }
        double x = NumberUtils.NaN();
        double y = NumberUtils.NaN();
        double z = NumberUtils.NaN();
        double m4 = NumberUtils.NaN();
        if (!point.isEmpty()) {
            x = point.getX();
            y = point.getY();
            if (b_export_zs) {
                z = point.getZ();
            }
            if (b_export_ms) {
                m4 = point.getM();
            }
        }
        if ((export_flags & 1) == 0) {
            OperatorExportToGeoJsonCursor.pointTaggedText_(precision, bFixedPoint, b_export_zs, b_export_ms, x, y, z, m4, json_writer);
        } else {
            OperatorExportToGeoJsonCursor.multiPointTaggedTextFromPoint_(precision, bFixedPoint, b_export_zs, b_export_ms, x, y, z, m4, json_writer);
        }
    }

    private static void exportEnvelopeToGeoJson_(int export_flags, Envelope envelope, JsonWriter json_writer) {
        boolean b_export_ms;
        int precision = 17 - (0x1F & export_flags >> 13);
        boolean bFixedPoint = (0x40000 & export_flags) != 0;
        boolean b_export_zs = envelope.hasAttribute(1) && (export_flags & 2) == 0;
        boolean bl = b_export_ms = envelope.hasAttribute(2) && (export_flags & 4) == 0;
        if (!b_export_zs && b_export_ms) {
            throw new IllegalArgumentException("invalid argument");
        }
        double xmin = NumberUtils.NaN();
        double ymin = NumberUtils.NaN();
        double xmax = NumberUtils.NaN();
        double ymax = NumberUtils.NaN();
        double zmin = NumberUtils.NaN();
        double zmax = NumberUtils.NaN();
        double mmin = NumberUtils.NaN();
        double mmax = NumberUtils.NaN();
        if (!envelope.isEmpty()) {
            Envelope1D interval;
            xmin = envelope.getXMin();
            ymin = envelope.getYMin();
            xmax = envelope.getXMax();
            ymax = envelope.getYMax();
            if (b_export_zs) {
                interval = envelope.queryInterval(1, 0);
                zmin = interval.vmin;
                zmax = interval.vmax;
            }
            if (b_export_ms) {
                interval = envelope.queryInterval(2, 0);
                mmin = interval.vmin;
                mmax = interval.vmax;
            }
        }
        if ((export_flags & 1) == 0) {
            OperatorExportToGeoJsonCursor.polygonTaggedTextFromEnvelope_(precision, bFixedPoint, b_export_zs, b_export_ms, xmin, ymin, xmax, ymax, zmin, zmax, mmin, mmax, json_writer);
        } else {
            OperatorExportToGeoJsonCursor.multiPolygonTaggedTextFromEnvelope_(precision, bFixedPoint, b_export_zs, b_export_ms, xmin, ymin, xmax, ymax, zmin, zmax, mmin, mmax, json_writer);
        }
    }

    private static void multiPolygonTaggedText_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, int polygon_count, int path_count, JsonWriter json_writer) {
        json_writer.addFieldName("type");
        json_writer.addValueString("MultiPolygon");
        json_writer.addFieldName("coordinates");
        if (position == null) {
            json_writer.startArray();
            json_writer.endArray();
            return;
        }
        json_writer.startArray();
        OperatorExportToGeoJsonCursor.multiPolygonText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, polygon_count, path_count, json_writer);
        json_writer.endArray();
    }

    private static void multiPolygonTaggedTextFromEnvelope_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, double xmin, double ymin, double xmax, double ymax, double zmin, double zmax, double mmin, double mmax, JsonWriter json_writer) {
        json_writer.addFieldName("type");
        json_writer.addValueString("MultiPolygon");
        json_writer.addFieldName("coordinates");
        if (NumberUtils.isNaN(xmin)) {
            json_writer.startArray();
            json_writer.endArray();
            return;
        }
        json_writer.startArray();
        OperatorExportToGeoJsonCursor.writeEnvelopeAsGeoJsonPolygon_(precision, bFixedPoint, b_export_zs, b_export_ms, xmin, ymin, xmax, ymax, zmin, zmax, mmin, mmax, json_writer);
        json_writer.endArray();
    }

    private static void multiLineStringTaggedText_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, int path_count, JsonWriter json_writer) {
        json_writer.addFieldName("type");
        json_writer.addValueString("MultiLineString");
        json_writer.addFieldName("coordinates");
        if (position == null) {
            json_writer.startArray();
            json_writer.endArray();
            return;
        }
        json_writer.startArray();
        OperatorExportToGeoJsonCursor.multiLineStringText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, path_flags, paths, path_count, json_writer);
        json_writer.endArray();
    }

    private static void multiPointTaggedText_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, int point_count, JsonWriter json_writer) {
        json_writer.addFieldName("type");
        json_writer.addValueString("MultiPoint");
        json_writer.addFieldName("coordinates");
        if (position == null) {
            json_writer.startArray();
            json_writer.endArray();
            return;
        }
        OperatorExportToGeoJsonCursor.lineStringText_(false, false, precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, 0, point_count, json_writer);
    }

    private static void multiPointTaggedTextFromPoint_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, double x, double y, double z, double m4, JsonWriter json_writer) {
        json_writer.addFieldName("type");
        json_writer.addValueString("MultiPoint");
        json_writer.addFieldName("coordinates");
        if (NumberUtils.isNaN(x)) {
            json_writer.startArray();
            json_writer.endArray();
            return;
        }
        json_writer.startArray();
        OperatorExportToGeoJsonCursor.pointText_(precision, bFixedPoint, b_export_zs, b_export_ms, x, y, z, m4, json_writer);
        json_writer.endArray();
    }

    private static void polygonTaggedText_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt32 paths, int path_count, JsonWriter json_writer) {
        json_writer.addFieldName("type");
        json_writer.addValueString("Polygon");
        json_writer.addFieldName("coordinates");
        if (position == null) {
            json_writer.startArray();
            json_writer.endArray();
            return;
        }
        OperatorExportToGeoJsonCursor.polygonText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, paths, 0, path_count, json_writer);
    }

    private static void polygonTaggedTextFromEnvelope_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, double xmin, double ymin, double xmax, double ymax, double zmin, double zmax, double mmin, double mmax, JsonWriter json_writer) {
        json_writer.addFieldName("type");
        json_writer.addValueString("Polygon");
        json_writer.addFieldName("coordinates");
        if (NumberUtils.isNaN(xmin)) {
            json_writer.startArray();
            json_writer.endArray();
            return;
        }
        OperatorExportToGeoJsonCursor.writeEnvelopeAsGeoJsonPolygon_(precision, bFixedPoint, b_export_zs, b_export_ms, xmin, ymin, xmax, ymax, zmin, zmax, mmin, mmax, json_writer);
    }

    private static void lineStringTaggedText_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, JsonWriter json_writer) {
        json_writer.addFieldName("type");
        json_writer.addValueString("LineString");
        json_writer.addFieldName("coordinates");
        if (position == null) {
            json_writer.startArray();
            json_writer.endArray();
            return;
        }
        boolean b_closed = (path_flags.read(0) & 1) != 0;
        OperatorExportToGeoJsonCursor.lineStringText_(false, b_closed, precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, 0, paths.read(1), json_writer);
    }

    private static void pointTaggedText_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, double x, double y, double z, double m4, JsonWriter json_writer) {
        json_writer.addFieldName("type");
        json_writer.addValueString("Point");
        json_writer.addFieldName("coordinates");
        if (NumberUtils.isNaN(x)) {
            json_writer.startArray();
            json_writer.endArray();
            return;
        }
        OperatorExportToGeoJsonCursor.pointText_(precision, bFixedPoint, b_export_zs, b_export_ms, x, y, z, m4, json_writer);
    }

    private static void multiPolygonText_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, int polygon_count, int path_count, JsonWriter json_writer) {
        int polygon_end;
        int polygon_start = 0;
        for (polygon_end = 1; polygon_end < path_count && (path_flags.read(polygon_end) & 4) == 0; ++polygon_end) {
        }
        OperatorExportToGeoJsonCursor.polygonText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, paths, polygon_start, polygon_end, json_writer);
        for (int ipolygon = 1; ipolygon < polygon_count; ++ipolygon) {
            polygon_start = polygon_end++;
            while (polygon_end < path_count && (path_flags.read(polygon_end) & 4) == 0) {
                ++polygon_end;
            }
            OperatorExportToGeoJsonCursor.polygonText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, paths, polygon_start, polygon_end, json_writer);
        }
    }

    private static void multiLineStringText_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt8 path_flags, AttributeStreamOfInt32 paths, int path_count, JsonWriter json_writer) {
        boolean b_closed = (path_flags.read(0) & 1) != 0;
        OperatorExportToGeoJsonCursor.lineStringText_(false, b_closed, precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, 0, paths.read(1), json_writer);
        for (int path = 1; path < path_count; ++path) {
            b_closed = (path_flags.read(path) & 1) != 0;
            int istart = paths.read(path);
            int iend = paths.read(path + 1);
            OperatorExportToGeoJsonCursor.lineStringText_(false, b_closed, precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, istart, iend, json_writer);
        }
    }

    private static void polygonText_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, AttributeStreamOfInt32 paths, int polygon_start, int polygon_end, JsonWriter json_writer) {
        json_writer.startArray();
        int istart = paths.read(polygon_start);
        int iend = paths.read(polygon_start + 1);
        OperatorExportToGeoJsonCursor.lineStringText_(true, true, precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, istart, iend, json_writer);
        for (int path = polygon_start + 1; path < polygon_end; ++path) {
            istart = paths.read(path);
            iend = paths.read(path + 1);
            OperatorExportToGeoJsonCursor.lineStringText_(true, true, precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, istart, iend, json_writer);
        }
        json_writer.endArray();
    }

    private static void lineStringText_(boolean bRing, boolean b_closed, int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, int istart, int iend, JsonWriter json_writer) {
        if (istart == iend) {
            json_writer.startArray();
            json_writer.endArray();
            return;
        }
        json_writer.startArray();
        if (bRing) {
            OperatorExportToGeoJsonCursor.pointText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, istart, json_writer);
            for (int point = iend - 1; point >= istart + 1; --point) {
                OperatorExportToGeoJsonCursor.pointText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, point, json_writer);
            }
            OperatorExportToGeoJsonCursor.pointText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, istart, json_writer);
        } else {
            for (int point = istart; point < iend - 1; ++point) {
                OperatorExportToGeoJsonCursor.pointText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, point, json_writer);
            }
            OperatorExportToGeoJsonCursor.pointText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, iend - 1, json_writer);
            if (b_closed) {
                OperatorExportToGeoJsonCursor.pointText_(precision, bFixedPoint, b_export_zs, b_export_ms, zs, ms, position, istart, json_writer);
            }
        }
        json_writer.endArray();
    }

    private static int pointText_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, double x, double y, double z, double m4, JsonWriter json_writer) {
        json_writer.startArray();
        json_writer.addValueDouble(x, precision, bFixedPoint);
        json_writer.addValueDouble(y, precision, bFixedPoint);
        if (b_export_zs) {
            json_writer.addValueDouble(z, precision, bFixedPoint);
        }
        if (b_export_ms) {
            json_writer.addValueDouble(m4, precision, bFixedPoint);
        }
        json_writer.endArray();
        return 1;
    }

    private static void pointText_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, AttributeStreamOfDbl zs, AttributeStreamOfDbl ms, AttributeStreamOfDbl position, int point, JsonWriter json_writer) {
        double x = position.readAsDbl(2 * point);
        double y = position.readAsDbl(2 * point + 1);
        double z = NumberUtils.NaN();
        double m4 = NumberUtils.NaN();
        if (b_export_zs) {
            double d = z = zs != null ? zs.readAsDbl(point) : VertexDescription.getDefaultValue(1);
        }
        if (b_export_ms) {
            m4 = ms != null ? ms.readAsDbl(point) : VertexDescription.getDefaultValue(2);
        }
        OperatorExportToGeoJsonCursor.pointText_(precision, bFixedPoint, b_export_zs, b_export_ms, x, y, z, m4, json_writer);
    }

    private static void writeEnvelopeAsGeoJsonPolygon_(int precision, boolean bFixedPoint, boolean b_export_zs, boolean b_export_ms, double xmin, double ymin, double xmax, double ymax, double zmin, double zmax, double mmin, double mmax, JsonWriter json_writer) {
        json_writer.startArray();
        json_writer.startArray();
        json_writer.startArray();
        json_writer.addValueDouble(xmin, precision, bFixedPoint);
        json_writer.addValueDouble(ymin, precision, bFixedPoint);
        if (b_export_zs) {
            json_writer.addValueDouble(zmin, precision, bFixedPoint);
        }
        if (b_export_ms) {
            json_writer.addValueDouble(mmin, precision, bFixedPoint);
        }
        json_writer.endArray();
        json_writer.startArray();
        json_writer.addValueDouble(xmax, precision, bFixedPoint);
        json_writer.addValueDouble(ymin, precision, bFixedPoint);
        if (b_export_zs) {
            json_writer.addValueDouble(zmax, precision, bFixedPoint);
        }
        if (b_export_ms) {
            json_writer.addValueDouble(mmax, precision, bFixedPoint);
        }
        json_writer.endArray();
        json_writer.startArray();
        json_writer.addValueDouble(xmax, precision, bFixedPoint);
        json_writer.addValueDouble(ymax, precision, bFixedPoint);
        if (b_export_zs) {
            json_writer.addValueDouble(zmin, precision, bFixedPoint);
        }
        if (b_export_ms) {
            json_writer.addValueDouble(mmin, precision, bFixedPoint);
        }
        json_writer.endArray();
        json_writer.startArray();
        json_writer.addValueDouble(xmin, precision, bFixedPoint);
        json_writer.addValueDouble(ymax, precision, bFixedPoint);
        if (b_export_zs) {
            json_writer.addValueDouble(zmax, precision, bFixedPoint);
        }
        if (b_export_ms) {
            json_writer.addValueDouble(mmax, precision, bFixedPoint);
        }
        json_writer.endArray();
        json_writer.startArray();
        json_writer.addValueDouble(xmin, precision, bFixedPoint);
        json_writer.addValueDouble(ymin, precision, bFixedPoint);
        if (b_export_zs) {
            json_writer.addValueDouble(zmin, precision, bFixedPoint);
        }
        if (b_export_ms) {
            json_writer.addValueDouble(mmin, precision, bFixedPoint);
        }
        json_writer.endArray();
        json_writer.endArray();
        json_writer.endArray();
    }
}

