/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.esri.core.geometry;

import com.hazelcast.com.esri.core.geometry.Bufferer;
import com.hazelcast.com.esri.core.geometry.Envelope2D;
import com.hazelcast.com.esri.core.geometry.Geometry;
import com.hazelcast.com.esri.core.geometry.GeometryCursor;
import com.hazelcast.com.esri.core.geometry.ProgressTracker;
import com.hazelcast.com.esri.core.geometry.SpatialReference;
import com.hazelcast.com.esri.core.geometry.SpatialReferenceImpl;

class OperatorBufferCursor
extends GeometryCursor {
    Bufferer m_bufferer = new Bufferer();
    private GeometryCursor m_inputGeoms;
    private SpatialReferenceImpl m_Spatial_reference;
    private ProgressTracker m_progress_tracker;
    private double[] m_distances;
    private Envelope2D m_currentUnionEnvelope2D;
    double m_max_deviation;
    int m_max_vertices_in_full_circle;
    private int m_index = -1;
    private int m_dindex;

    OperatorBufferCursor(GeometryCursor inputGeoms, SpatialReference sr, double[] distances, double max_deviation, int max_vertices, boolean b_union, ProgressTracker progress_tracker) {
        this.m_inputGeoms = inputGeoms;
        this.m_max_deviation = max_deviation;
        this.m_max_vertices_in_full_circle = max_vertices;
        this.m_Spatial_reference = (SpatialReferenceImpl)sr;
        this.m_distances = distances;
        this.m_currentUnionEnvelope2D = new Envelope2D();
        this.m_currentUnionEnvelope2D.setEmpty();
        this.m_dindex = -1;
        this.m_progress_tracker = progress_tracker;
    }

    @Override
    public Geometry next() {
        Geometry geom = this.m_inputGeoms.next();
        if (geom != null) {
            this.m_index = this.m_inputGeoms.getGeometryID();
            if (this.m_dindex + 1 < this.m_distances.length) {
                ++this.m_dindex;
            }
            return this.buffer(geom, this.m_distances[this.m_dindex]);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    Geometry buffer(Geometry geom, double distance) {
        return this.m_bufferer.buffer(geom, distance, this.m_Spatial_reference, this.m_max_deviation, this.m_max_vertices_in_full_circle, this.m_progress_tracker);
    }
}

