/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jdbc;

import com.hazelcast.jdbc.HazelcastSqlClient;
import com.hazelcast.jdbc.JdbcConnection;
import com.hazelcast.jdbc.JdbcUrl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class Driver
implements java.sql.Driver {
    static final int VER_MAJOR = 4;
    static final int VER_MINOR = 0;
    private static final Driver INSTANCE = new Driver();
    private static boolean registered;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        JdbcUrl jdbcUrl;
        if (url == null) {
            throw new SQLException("URL is null");
        }
        if (!JdbcUrl.acceptsUrl(url)) {
            return null;
        }
        try {
            jdbcUrl = new JdbcUrl(url, info);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e.getMessage(), e);
        }
        return new JdbcConnection(new HazelcastSqlClient(jdbcUrl));
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("URL is null");
        }
        return JdbcUrl.acceptsUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 4;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("The driver does not use java.util.logging");
    }

    private static void load() {
        try {
            if (!registered) {
                DriverManager.registerDriver(INSTANCE);
                registered = true;
            }
        }
        catch (SQLException exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    static {
        Driver.load();
    }
}

