/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SemaphoreAcquireCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreAvailablePermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreDrainPermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreIncreasePermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreInitCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreReducePermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreReleaseCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreTryAcquireCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.core.ISemaphore;
import java.util.concurrent.TimeUnit;

public class ClientSemaphoreProxy
extends PartitionSpecificClientProxy
implements ISemaphore {
    public ClientSemaphoreProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    public boolean init(int permits) {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreInitCodec.encodeRequest((String)this.name, (int)permits);
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreInitCodec.ResponseParameters resultParameters = SemaphoreInitCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void acquire() throws InterruptedException {
        ClientMessage request = SemaphoreAcquireCodec.encodeRequest((String)this.name, (int)1);
        this.invokeOnPartition(request);
    }

    public void acquire(int permits) throws InterruptedException {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreAcquireCodec.encodeRequest((String)this.name, (int)permits);
        this.invokeOnPartition(request);
    }

    public int availablePermits() {
        ClientMessage request = SemaphoreAvailablePermitsCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreAvailablePermitsCodec.ResponseParameters resultParameters = SemaphoreAvailablePermitsCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public int drainPermits() {
        ClientMessage request = SemaphoreDrainPermitsCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreDrainPermitsCodec.ResponseParameters resultParameters = SemaphoreDrainPermitsCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void reducePermits(int reduction) {
        this.checkNegative(reduction);
        ClientMessage request = SemaphoreReducePermitsCodec.encodeRequest((String)this.name, (int)reduction);
        this.invokeOnPartition(request);
    }

    public void increasePermits(int increase) {
        this.checkNegative(increase);
        ClientMessage request = SemaphoreIncreasePermitsCodec.encodeRequest((String)this.name, (int)increase);
        this.invokeOnPartition(request);
    }

    public void release() {
        ClientMessage request = SemaphoreReleaseCodec.encodeRequest((String)this.name, (int)1);
        this.invokeOnPartition(request);
    }

    public void release(int permits) {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreReleaseCodec.encodeRequest((String)this.name, (int)permits);
        this.invokeOnPartition(request);
    }

    public boolean tryAcquire() {
        ClientMessage request = SemaphoreTryAcquireCodec.encodeRequest((String)this.name, (int)1, (long)0L);
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreTryAcquireCodec.ResponseParameters resultParameters = SemaphoreTryAcquireCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean tryAcquire(int permits) {
        this.checkNegative(permits);
        try {
            return this.tryAcquire(permits, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout == 0L) {
            return this.tryAcquire();
        }
        ClientMessage request = SemaphoreTryAcquireCodec.encodeRequest((String)this.name, (int)1, (long)unit.toMillis(timeout));
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreTryAcquireCodec.ResponseParameters resultParameters = SemaphoreTryAcquireCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreTryAcquireCodec.encodeRequest((String)this.name, (int)permits, (long)unit.toMillis(timeout));
        ClientMessage response = this.invokeOnPartition(request);
        SemaphoreTryAcquireCodec.ResponseParameters resultParameters = SemaphoreTryAcquireCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    private void checkNegative(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits cannot be negative!");
        }
    }

    public String toString() {
        return "ISemaphore{name='" + this.name + '\'' + '}';
    }
}

