/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.proxy;

import com.hazelcast.client.cp.internal.datastructures.atomiclong.RaftAtomicLongProxy;
import com.hazelcast.client.cp.internal.datastructures.atomicref.RaftAtomicRefProxy;
import com.hazelcast.client.cp.internal.datastructures.countdownlatch.RaftCountDownLatchProxy;
import com.hazelcast.client.cp.internal.datastructures.lock.RaftFencedLockProxy;
import com.hazelcast.client.cp.internal.datastructures.semaphore.RaftSessionAwareSemaphoreProxy;
import com.hazelcast.client.cp.internal.datastructures.semaphore.RaftSessionlessSemaphoreProxy;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPGroupCreateCPGroupCodec;
import com.hazelcast.client.impl.protocol.codec.CPSemaphoreGetSemaphoreTypeCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.lock.FencedLock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientRaftProxyFactory {
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentMap<String, RaftFencedLockProxy> lockProxies = new ConcurrentHashMap<String, RaftFencedLockProxy>();
    private ClientContext context;

    public ClientRaftProxyFactory(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    public void init(ClientContext context) {
        this.context = context;
    }

    public <T extends DistributedObject> T createProxy(String serviceName, String proxyName) {
        proxyName = RaftService.withoutDefaultGroupName((String)proxyName);
        String objectName = RaftService.getObjectNameForProxy((String)proxyName);
        RaftGroupId groupId = this.getGroupId(proxyName, objectName);
        if (serviceName.equals("hz:raft:atomicLongService")) {
            return (T)new RaftAtomicLongProxy(this.context, groupId, proxyName, objectName);
        }
        if (serviceName.equals("hz:raft:atomicRefService")) {
            return (T)new RaftAtomicRefProxy(this.context, groupId, proxyName, objectName);
        }
        if (serviceName.equals("hz:raft:countDownLatchService")) {
            return (T)new RaftCountDownLatchProxy(this.context, groupId, proxyName, objectName);
        }
        if (serviceName.equals("hz:raft:lockService")) {
            return (T)this.createFencedLock(groupId, proxyName, objectName);
        }
        if (serviceName.equals("hz:raft:semaphoreService")) {
            return (T)this.createSemaphore(groupId, proxyName, objectName);
        }
        throw new IllegalArgumentException();
    }

    private FencedLock createFencedLock(RaftGroupId groupId, String proxyName, String objectName) {
        while (true) {
            RaftFencedLockProxy existing;
            RaftFencedLockProxy proxy;
            if ((proxy = (RaftFencedLockProxy)this.lockProxies.get(proxyName)) != null) {
                if (!proxy.getGroupId().equals(groupId)) {
                    this.lockProxies.remove(proxyName, proxy);
                } else {
                    return proxy;
                }
            }
            if ((existing = this.lockProxies.putIfAbsent(proxyName, proxy = new RaftFencedLockProxy(this.context, groupId, proxyName, objectName))) == null) {
                return proxy;
            }
            if (existing.getGroupId().equals(groupId)) {
                return existing;
            }
            groupId = this.getGroupId(proxyName, objectName);
        }
    }

    private ISemaphore createSemaphore(RaftGroupId groupId, String proxyName, String objectName) {
        ClientMessage request = CPSemaphoreGetSemaphoreTypeCodec.encodeRequest((String)proxyName);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.client, request, objectName).invoke().join();
        boolean jdkCompatible = CPSemaphoreGetSemaphoreTypeCodec.decodeResponse((ClientMessage)response).response;
        return jdkCompatible ? new RaftSessionlessSemaphoreProxy(this.context, groupId, proxyName, objectName) : new RaftSessionAwareSemaphoreProxy(this.context, groupId, proxyName, objectName);
    }

    private RaftGroupId getGroupId(String proxyName, String objectName) {
        ClientMessage request = CPGroupCreateCPGroupCodec.encodeRequest((String)proxyName);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.client, request, objectName).invoke().join();
        return CPGroupCreateCPGroupCodec.decodeResponse((ClientMessage)response).groupId;
    }
}

