/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.ClientFailoverConfigSections;
import com.hazelcast.client.config.YamlClientFailoverConfigLocator;
import com.hazelcast.client.config.YamlClientFailoverDomConfigProcessor;
import com.hazelcast.config.AbstractYamlConfigBuilder;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.yaml.W3cDomUtil;
import com.hazelcast.config.yaml.YamlDomChecker;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.yaml.YamlLoader;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlNode;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.w3c.dom.Node;

public class YamlClientFailoverConfigBuilder
extends AbstractYamlConfigBuilder {
    private final InputStream in;

    public YamlClientFailoverConfigBuilder(String resource) throws IOException {
        URL url = ConfigLoader.locateConfig((String)resource);
        Preconditions.checkTrue((url != null ? 1 : 0) != 0, (String)("Could not load " + resource));
        this.in = url.openStream();
    }

    public YamlClientFailoverConfigBuilder(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (String)"File is null!");
        this.in = new FileInputStream(file);
    }

    public YamlClientFailoverConfigBuilder(URL url) throws IOException {
        Preconditions.checkNotNull((Object)url, (String)"URL is null!");
        this.in = url.openStream();
    }

    public YamlClientFailoverConfigBuilder(InputStream in) {
        this.in = in;
    }

    public YamlClientFailoverConfigBuilder() {
        this((YamlClientFailoverConfigLocator)null);
    }

    public YamlClientFailoverConfigBuilder(YamlClientFailoverConfigLocator locator) {
        if (locator == null) {
            locator = new YamlClientFailoverConfigLocator(true);
            locator.locateEverywhere();
        }
        if (!locator.isConfigPresent()) {
            throw new HazelcastException("Failed to load ClientFailoverConfig");
        }
        this.in = locator.getIn();
    }

    public ClientFailoverConfig build() {
        ClientFailoverConfig clientFailoverConfig = new ClientFailoverConfig();
        this.build(clientFailoverConfig);
        return clientFailoverConfig;
    }

    public void setProperties(Properties properties) {
        this.setPropertiesInternal(properties);
    }

    void build(ClientFailoverConfig clientFailoverConfig) {
        try {
            this.parseAndBuildConfig(clientFailoverConfig);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            IOUtil.closeResource((Closeable)this.in);
        }
    }

    private void parseAndBuildConfig(ClientFailoverConfig config) throws Exception {
        YamlMapping yamlRootNode;
        try {
            yamlRootNode = (YamlMapping)YamlLoader.load((InputStream)this.in);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Invalid YAML configuration", (Throwable)ex);
        }
        String configRoot = this.getConfigRoot();
        YamlMapping clientFailoverRoot = yamlRootNode.childAsMapping(configRoot);
        if (clientFailoverRoot == null) {
            String message = String.format("No mapping with %s key is found in the provided configuration", configRoot);
            throw new InvalidConfigurationException(message);
        }
        YamlDomChecker.check((YamlNode)clientFailoverRoot);
        Node w3cRootNode = W3cDomUtil.asW3cNode((YamlNode)clientFailoverRoot);
        this.replaceVariables(w3cRootNode);
        this.importDocuments((YamlNode)clientFailoverRoot);
        new YamlClientFailoverDomConfigProcessor(true, config).buildConfig(w3cRootNode);
    }

    protected String getConfigRoot() {
        return ClientFailoverConfigSections.CLIENT_FAILOVER.name;
    }
}

