/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.collection;

import java.util.Arrays;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> T[] createCopy(T[] src) {
        return Arrays.copyOf(src, src.length);
    }

    public static <T> void copyWithoutNulls(T[] src, T[] dst) {
        int skipped = 0;
        for (int i = 0; i < src.length; ++i) {
            T object = src[i];
            if (object == null) {
                ++skipped;
                continue;
            }
            dst[i - skipped] = object;
        }
    }

    public static <T> boolean contains(T[] array, T item) {
        for (T o : array) {
            if (!(o == null ? item == null : o.equals(item))) continue;
            return true;
        }
        return false;
    }

    public static <T> T getItemAtPositionOrNull(T[] array, int position) {
        if (array.length > position) {
            return array[position];
        }
        return null;
    }

    public static <T> void concat(T[] sourceFirst, T[] sourceSecond, T[] dest) {
        System.arraycopy(sourceFirst, 0, dest, 0, sourceFirst.length);
        System.arraycopy(sourceSecond, 0, dest, sourceFirst.length, sourceSecond.length);
    }
}

