/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.ReadonlyOperation;
import java.io.IOException;

public class PartitionCheckIfLoadedOperation
extends MapOperation
implements PartitionAwareOperation,
ReadonlyOperation {
    private boolean isFinished;
    private boolean doLoad;
    private boolean waitForKeyLoad;

    public PartitionCheckIfLoadedOperation() {
    }

    public PartitionCheckIfLoadedOperation(String name) {
        this(name, false);
    }

    public PartitionCheckIfLoadedOperation(String name, boolean doLoad) {
        this(name, doLoad, false);
    }

    public PartitionCheckIfLoadedOperation(String name, boolean doLoad, boolean waitForKeyLoad) {
        super(name);
        this.doLoad = doLoad;
        this.waitForKeyLoad = waitForKeyLoad;
    }

    @Override
    public void run() {
        this.isFinished = this.recordStore.isLoaded();
        if (this.doLoad) {
            this.recordStore.maybeDoInitialLoad();
        }
        if (this.waitForKeyLoad) {
            this.recordStore.onKeyLoad(new CallbackResponseSender());
        }
    }

    @Override
    public Object getResponse() {
        return this.isFinished;
    }

    @Override
    public boolean returnsResponse() {
        return !this.waitForKeyLoad;
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (!this.returnsResponse()) {
            this.sendResponse(e);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.doLoad);
        out.writeBoolean(this.waitForKeyLoad);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.doLoad = in.readBoolean();
        this.waitForKeyLoad = in.readBoolean();
    }

    private class CallbackResponseSender
    implements ExecutionCallback<Boolean> {
        private CallbackResponseSender() {
        }

        @Override
        public void onResponse(Boolean response) {
            PartitionCheckIfLoadedOperation.this.sendResponse(response);
        }

        @Override
        public void onFailure(Throwable error) {
            PartitionCheckIfLoadedOperation.this.sendResponse(error);
        }
    }
}

