/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.jmx;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.jmx.HazelcastMBean;
import com.hazelcast.internal.jmx.ManagedAnnotation;
import com.hazelcast.internal.jmx.ManagedDescription;
import com.hazelcast.internal.jmx.ManagementService;
import com.hazelcast.nio.ConnectionManager;
import java.util.Hashtable;

@ManagedDescription(value="HazelcastInstance.ConnectionManager")
public class ConnectionManagerMBean
extends HazelcastMBean<ConnectionManager> {
    public ConnectionManagerMBean(HazelcastInstance hazelcastInstance, ConnectionManager connectionManager, ManagementService service) {
        super(connectionManager, service);
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        properties.put("type", ManagementService.quote("HazelcastInstance.ConnectionManager"));
        properties.put("instance", ManagementService.quote(hazelcastInstance.getName()));
        properties.put("name", ManagementService.quote(hazelcastInstance.getName()));
        this.setObjectName(properties);
    }

    public ConnectionManager getConnectionManager() {
        return (ConnectionManager)this.managedObject;
    }

    @ManagedAnnotation(value="clientConnectionCount")
    @ManagedDescription(value="Current number of client connections")
    public int getCurrentClientConnections() {
        return this.getConnectionManager().getCurrentClientConnections();
    }

    @ManagedAnnotation(value="activeConnectionCount")
    @ManagedDescription(value="Current number of active connections")
    public int getActiveConnectionCount() {
        return this.getConnectionManager().getActiveConnectionCount();
    }

    @ManagedAnnotation(value="connectionCount")
    @ManagedDescription(value="Current number of connections")
    public int getConnectionCount() {
        return this.getConnectionManager().getConnectionCount();
    }
}

