/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@PrivateApi
public abstract class AbstractMember
implements Member {
    protected final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    protected Address address;
    protected String uuid;
    protected boolean liteMember;

    protected AbstractMember() {
    }

    protected AbstractMember(Address address) {
        this(address, null, null);
    }

    protected AbstractMember(Address address, String uuid) {
        this(address, uuid, null);
    }

    protected AbstractMember(Address address, String uuid, Map<String, Object> attributes) {
        this(address, uuid, attributes, false);
    }

    protected AbstractMember(Address address, String uuid, Map<String, Object> attributes, boolean liteMember) {
        this.address = address;
        this.uuid = uuid;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
        this.liteMember = liteMember;
    }

    protected AbstractMember(AbstractMember member) {
        this.address = member.address;
        this.uuid = member.uuid;
        this.attributes.putAll(member.attributes);
        this.liteMember = member.liteMember;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.address.getPort();
    }

    public InetAddress getInetAddress() {
        try {
            return this.address.getInetAddress();
        }
        catch (UnknownHostException e) {
            if (this.getLogger() != null) {
                this.getLogger().warning(e);
            }
            return null;
        }
    }

    protected abstract ILogger getLogger();

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.getSocketAddress();
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        try {
            return this.address.getInetSocketAddress();
        }
        catch (UnknownHostException e) {
            if (this.getLogger() != null) {
                this.getLogger().warning(e);
            }
            return null;
        }
    }

    void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public boolean isLiteMember() {
        return this.liteMember;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void updateAttribute(MemberAttributeOperationType operationType, String key, Object value) {
        switch (operationType) {
            case PUT: {
                this.attributes.put(key, value);
                break;
            }
            case REMOVE: {
                this.attributes.remove(key);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a known OperationType " + (Object)((Object)operationType));
            }
        }
    }

    protected Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.address = new Address();
        this.address.readData(in);
        this.uuid = in.readUTF();
        this.liteMember = in.readBoolean();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            Object value = IOUtil.readAttributeValue(in);
            this.attributes.put(key, value);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.address.writeData(out);
        out.writeUTF(this.uuid);
        out.writeBoolean(this.liteMember);
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes);
        out.writeInt(attributes.size());
        for (Map.Entry entry : attributes.entrySet()) {
            out.writeUTF((String)entry.getKey());
            IOUtil.writeAttributeValue(entry.getValue(), out);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Member [");
        sb.append(this.address.getHost());
        sb.append("]");
        sb.append(":");
        sb.append(this.address.getPort());
        sb.append(" - ").append(this.uuid);
        if (this.localMember()) {
            sb.append(" this");
        }
        if (this.isLiteMember()) {
            sb.append(" lite");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractMember)) {
            return false;
        }
        AbstractMember other = (AbstractMember)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }
}

