/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.util.Preconditions;

public class AwsConfig {
    private static final int CONNECTION_TIMEOUT = 5;
    private boolean enabled;
    private String accessKey;
    private String secretKey;
    private String region = "us-east-1";
    private String securityGroupName;
    private String tagKey;
    private String tagValue;
    private String hostHeader = "ec2.amazonaws.com";
    private String iamRole;
    private int connectionTimeoutSeconds = 5;

    public String getAccessKey() {
        return this.accessKey;
    }

    public AwsConfig setAccessKey(String accessKey) {
        this.accessKey = Preconditions.checkHasText(accessKey, "accessKey must contain text");
        return this;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public AwsConfig setSecretKey(String secretKey) {
        this.secretKey = Preconditions.checkHasText(secretKey, "secretKey must contain text");
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public AwsConfig setRegion(String region) {
        this.region = Preconditions.checkHasText(region, "region must contain text");
        return this;
    }

    public String getHostHeader() {
        return this.hostHeader;
    }

    public AwsConfig setHostHeader(String hostHeader) {
        this.hostHeader = Preconditions.checkHasText(hostHeader, "hostHeader must contain text");
        return this;
    }

    public AwsConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public AwsConfig setSecurityGroupName(String securityGroupName) {
        this.securityGroupName = securityGroupName;
        return this;
    }

    public String getSecurityGroupName() {
        return this.securityGroupName;
    }

    public AwsConfig setTagKey(String tagKey) {
        this.tagKey = tagKey;
        return this;
    }

    public AwsConfig setTagValue(String tagValue) {
        this.tagValue = tagValue;
        return this;
    }

    public String getTagKey() {
        return this.tagKey;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public int getConnectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds;
    }

    public AwsConfig setConnectionTimeoutSeconds(int connectionTimeoutSeconds) {
        if (connectionTimeoutSeconds < 0) {
            throw new IllegalArgumentException("connection timeout can't be smaller than 0");
        }
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        return this;
    }

    public String getIamRole() {
        return this.iamRole;
    }

    public AwsConfig setIamRole(String iamRole) {
        this.iamRole = iamRole;
        return this;
    }

    public String toString() {
        return "AwsConfig{enabled=" + this.enabled + ", region='" + this.region + '\'' + ", securityGroupName='" + this.securityGroupName + '\'' + ", tagKey='" + this.tagKey + '\'' + ", tagValue='" + this.tagValue + '\'' + ", hostHeader='" + this.hostHeader + '\'' + ", iamRole='" + this.iamRole + '\'' + ", connectionTimeoutSeconds=" + this.connectionTimeoutSeconds + '}';
    }
}

