/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TransactionalListAddCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalListRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalListSizeCodec;
import com.hazelcast.client.proxy.txn.AbstractClientTxnCollectionProxy;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.core.TransactionalList;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;

public class ClientTxnListProxy<E>
extends AbstractClientTxnCollectionProxy<E>
implements TransactionalList<E> {
    public ClientTxnListProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:listService";
    }

    @Override
    public boolean add(E e) {
        Preconditions.checkNotNull(e);
        Data value = this.toData(e);
        ClientMessage request = TransactionalListAddCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), value);
        ClientMessage response = this.invoke(request);
        return TransactionalListAddCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public boolean remove(E e) {
        Preconditions.checkNotNull(e);
        Data value = this.toData(e);
        ClientMessage request = TransactionalListRemoveCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), value);
        ClientMessage response = this.invoke(request);
        return TransactionalListRemoveCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public int size() {
        ClientMessage request = TransactionalListSizeCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return TransactionalListSizeCodec.decodeResponse((ClientMessage)response).response;
    }
}

