/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.ClientEndpointManagerImpl;
import com.hazelcast.core.ClientType;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.util.Clock;
import com.hazelcast.util.StringUtil;
import java.util.concurrent.TimeUnit;

public class ClientHeartbeatMonitor
implements Runnable {
    private static final int HEART_BEAT_CHECK_INTERVAL_SECONDS = 10;
    private static final int DEFAULT_CLIENT_HEARTBEAT_TIMEOUT_SECONDS = 60;
    private final ClientEndpointManagerImpl clientEndpointManager;
    private final ClientEngine clientEngine;
    private final long heartbeatTimeoutSeconds;
    private final ExecutionService executionService;

    public ClientHeartbeatMonitor(ClientEndpointManagerImpl endpointManager, ClientEngine clientEngine, ExecutionService executionService, HazelcastProperties hazelcastProperties) {
        this.clientEndpointManager = endpointManager;
        this.clientEngine = clientEngine;
        this.executionService = executionService;
        this.heartbeatTimeoutSeconds = this.getHeartbeatTimeout(hazelcastProperties);
    }

    private long getHeartbeatTimeout(HazelcastProperties hazelcastProperties) {
        long configuredTimeout = hazelcastProperties.getSeconds(GroupProperty.CLIENT_HEARTBEAT_TIMEOUT_SECONDS);
        if (configuredTimeout > 0L) {
            return configuredTimeout;
        }
        return 60L;
    }

    public void start() {
        this.executionService.scheduleWithRepetition(this, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        String memberUuid = this.clientEngine.getLocalMember().getUuid();
        for (ClientEndpoint ce : this.clientEndpointManager.getEndpoints()) {
            ClientEndpointImpl clientEndpoint = (ClientEndpointImpl)ce;
            this.monitor(memberUuid, clientEndpoint);
        }
    }

    private void monitor(String memberUuid, ClientEndpointImpl clientEndpoint) {
        long currentTimeMillis;
        long timeoutInMillis;
        if (clientEndpoint.isFirstConnection() && ClientType.CPP.equals((Object)clientEndpoint.getClientType())) {
            return;
        }
        Connection connection = clientEndpoint.getConnection();
        long lastTimePacketReceived = connection.lastReadTimeMillis();
        if (lastTimePacketReceived + (timeoutInMillis = TimeUnit.SECONDS.toMillis(this.heartbeatTimeoutSeconds)) < (currentTimeMillis = Clock.currentTimeMillis()) && memberUuid.equals(this.clientEngine.getOwnerUuid(clientEndpoint.getUuid()))) {
            String message = "Client heartbeat is timed out, closing connection to " + connection + ". Now: " + StringUtil.timeToString(currentTimeMillis) + ". LastTimePacketReceived: " + StringUtil.timeToString(lastTimePacketReceived);
            connection.close(message, null);
        }
    }
}

