/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.impl.tx;

import com.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.queue.impl.QueueOperation;
import java.io.IOException;

public class TxnPeekOperation
extends QueueOperation {
    private long itemId;
    private String transactionId;

    public TxnPeekOperation() {
    }

    public TxnPeekOperation(String name, long timeoutMillis, long itemId, String transactionId) {
        super(name, timeoutMillis);
        this.itemId = itemId;
        this.transactionId = transactionId;
    }

    @Override
    public void run() throws Exception {
        this.response = this.getOrCreateContainer().txnPeek(this.itemId, this.transactionId);
    }

    @Override
    public void afterRun() throws Exception {
        if (this.response != null) {
            LocalQueueStatsImpl localQueueStatsImpl = this.getQueueService().getLocalQueueStatsImpl(this.name);
            localQueueStatsImpl.incrementOtherOperations();
        }
    }

    @Override
    public int getId() {
        return 39;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeUTF(this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.transactionId = in.readUTF();
    }
}

