/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapreduce.impl;

import com.hazelcast.mapreduce.JobPartitionState;
import com.hazelcast.mapreduce.impl.task.JobPartitionStateImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;

public class JobPartitionStateSerializerHook
implements SerializerHook<JobPartitionStateImpl> {
    @Override
    public Class<JobPartitionStateImpl> getSerializationType() {
        return JobPartitionStateImpl.class;
    }

    @Override
    public Serializer createSerializer() {
        return new JobPartitionStateSerializer();
    }

    @Override
    public boolean isOverwritable() {
        return false;
    }

    private static class JobPartitionStateSerializer
    implements StreamSerializer<JobPartitionStateImpl> {
        private JobPartitionStateSerializer() {
        }

        @Override
        public void write(ObjectDataOutput out, JobPartitionStateImpl partitionState) throws IOException {
            out.writeBoolean(partitionState != null);
            if (partitionState != null) {
                out.writeObject(partitionState.getOwner());
                out.writeInt(partitionState.getState().ordinal());
            }
        }

        @Override
        public JobPartitionStateImpl read(ObjectDataInput in) throws IOException {
            if (in.readBoolean()) {
                Address owner = (Address)in.readObject();
                JobPartitionState.State state = JobPartitionState.State.byOrdinal(in.readInt());
                return new JobPartitionStateImpl(owner, state);
            }
            return null;
        }

        @Override
        public int getTypeId() {
            return -101;
        }

        @Override
        public void destroy() {
        }
    }
}

