/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl.client;

import com.hazelcast.client.impl.client.InvocationClientRequest;
import com.hazelcast.executor.impl.CancellationOperation;
import com.hazelcast.executor.impl.ExecutorPortableHook;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.ExecutionException;

public class CancellationRequest
extends InvocationClientRequest {
    static final int CANCEL_TRY_COUNT = 50;
    static final int CANCEL_TRY_PAUSE_MILLIS = 250;
    private String uuid;
    private Address target;
    private int partitionId = -1;
    private boolean interrupt;

    public CancellationRequest() {
    }

    public CancellationRequest(String uuid, Address target, boolean interrupt) {
        this.uuid = uuid;
        this.target = target;
        this.interrupt = interrupt;
    }

    public CancellationRequest(String uuid, int partitionId, boolean interrupt) {
        this.uuid = uuid;
        this.partitionId = partitionId;
        this.interrupt = interrupt;
    }

    @Override
    protected void invoke() {
        CancellationOperation op = new CancellationOperation(this.uuid, this.interrupt);
        InvocationBuilder builder = this.target != null ? this.createInvocationBuilder(this.getServiceName(), (Operation)op, this.target) : this.createInvocationBuilder(this.getServiceName(), (Operation)op, this.partitionId);
        builder.setTryCount(50).setTryPauseMillis(250L);
        InternalCompletableFuture future = builder.invoke();
        boolean result = false;
        try {
            result = (Boolean)future.get();
        }
        catch (InterruptedException e) {
            this.logException(e);
        }
        catch (ExecutionException e) {
            this.logException(e);
        }
        this.getEndpoint().sendResponse(result, this.getCallId());
    }

    private void logException(Exception e) {
        ILogger logger = this.getClientEngine().getLogger(CancellationRequest.class);
        logger.warning(e);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public int getFactoryId() {
        return ExecutorPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("u", this.uuid);
        writer.writeInt("p", this.partitionId);
        writer.writeBoolean("i", this.interrupt);
        ObjectDataOutput rawDataOutput = writer.getRawDataOutput();
        rawDataOutput.writeObject(this.target);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.uuid = reader.readUTF("u");
        this.partitionId = reader.readInt("p");
        this.interrupt = reader.readBoolean("i");
        ObjectDataInput rawDataInput = reader.getRawDataInput();
        this.target = (Address)rawDataInput.readObject();
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

