/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionEvent;
import com.hazelcast.collection.CollectionTransactionRollbackOperation;
import com.hazelcast.collection.common.DataAwareItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.TransactionalService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public abstract class CollectionService
implements ManagedService,
RemoteService,
EventPublishingService<CollectionEvent, ItemListener>,
TransactionalService,
MigrationAwareService {
    protected final NodeEngine nodeEngine;
    private final ILogger logger;

    protected CollectionService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        this.getContainerMap().clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.getContainerMap().remove(name);
        this.nodeEngine.getEventService().deregisterAllListeners(this.getServiceName(), name);
    }

    public abstract CollectionContainer getOrCreateContainer(String var1, boolean var2);

    public abstract Map<String, ? extends CollectionContainer> getContainerMap();

    public abstract String getServiceName();

    @Override
    public void dispatchEvent(CollectionEvent event, ItemListener listener) {
        MemberImpl member = this.nodeEngine.getClusterService().getMember(event.caller);
        DataAwareItemEvent itemEvent = new DataAwareItemEvent(event.name, event.eventType, event.data, member, this.nodeEngine.getSerializationService());
        if (member == null) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("Dropping event " + itemEvent + " from unknown address:" + event.caller);
            }
            return;
        }
        if (event.eventType.equals((Object)ItemEventType.ADDED)) {
            listener.itemAdded(itemEvent);
        } else {
            listener.itemRemoved(itemEvent);
        }
    }

    @Override
    public void rollbackTransaction(String transactionId) {
        Set<String> collectionNames = this.getContainerMap().keySet();
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        OperationService operationService = this.nodeEngine.getOperationService();
        for (String name : collectionNames) {
            int partitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            Operation operation = new CollectionTransactionRollbackOperation(name, transactionId).setPartitionId(partitionId).setService(this).setNodeEngine(this.nodeEngine);
            operationService.executeOperation(operation);
        }
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    public Map<String, CollectionContainer> getMigrationData(PartitionReplicationEvent event) {
        HashMap<String, CollectionContainer> migrationData = new HashMap<String, CollectionContainer>();
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        for (Map.Entry<String, ? extends CollectionContainer> entry : this.getContainerMap().entrySet()) {
            String name = entry.getKey();
            int partitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            CollectionContainer container = entry.getValue();
            if (partitionId != event.getPartitionId() || container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            migrationData.put(name, container);
        }
        return migrationData;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearMigrationData(event.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearMigrationData(event.getPartitionId());
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.clearMigrationData(partitionId);
    }

    private void clearMigrationData(int partitionId) {
        Set<Map.Entry<String, ? extends CollectionContainer>> entrySet = this.getContainerMap().entrySet();
        Iterator<Map.Entry<String, ? extends CollectionContainer>> iterator = entrySet.iterator();
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends CollectionContainer> entry = iterator.next();
            String name = entry.getKey();
            CollectionContainer container = entry.getValue();
            int containerPartitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            if (containerPartitionId != partitionId) continue;
            container.destroy();
            iterator.remove();
        }
    }

    public void addContainer(String name, CollectionContainer container) {
        Map<String, ? extends CollectionContainer> map = this.getContainerMap();
        map.put(name, container);
    }
}

