/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheEntry;
import com.hazelcast.cache.impl.CacheEntryProcessorEntry;
import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventDataImpl;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.cache.impl.CacheKeyIteratorResult;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.cache.impl.record.CacheRecordFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.EventServiceImpl;
import com.hazelcast.util.CacheConcurrentHashMap;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.cache.configuration.Factory;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.processor.EntryProcessor;

public class CacheRecordStore
implements ICacheRecordStore {
    private static final long INITIAL_DELAY = 5L;
    private static final long PERIOD = 5L;
    final String name;
    final int partitionId;
    final NodeEngine nodeEngine;
    final CacheService cacheService;
    final CacheConfig cacheConfig;
    final CacheConcurrentHashMap<Data, CacheRecord> records = new CacheConcurrentHashMap(1000);
    final CacheRecordFactory cacheRecordFactory;
    final ScheduledFuture<?> evictionTaskFuture;
    CacheStatisticsImpl statistics;
    private CacheLoader cacheLoader;
    private CacheWriter cacheWriter;
    private boolean hasExpiringEntry;
    private boolean isEventsEnabled = true;
    private boolean isEventBatchingEnabled;
    private ExpiryPolicy defaultExpiryPolicy;
    private Map<CacheEventType, Set<CacheEventData>> batchEvent = new HashMap<CacheEventType, Set<CacheEventData>>();

    CacheRecordStore(String name, int partitionId, NodeEngine nodeEngine, CacheService cacheService) {
        this.name = name;
        this.partitionId = partitionId;
        this.nodeEngine = nodeEngine;
        this.cacheService = cacheService;
        this.cacheConfig = cacheService.getCacheConfig(name);
        if (this.cacheConfig == null) {
            throw new IllegalStateException("Cache already destroyed");
        }
        if (this.cacheConfig.getCacheLoaderFactory() != null) {
            Factory cacheLoaderFactory = this.cacheConfig.getCacheLoaderFactory();
            this.cacheLoader = (CacheLoader)cacheLoaderFactory.create();
        }
        if (this.cacheConfig.getCacheWriterFactory() != null) {
            Factory cacheWriterFactory = this.cacheConfig.getCacheWriterFactory();
            this.cacheWriter = (CacheWriter)cacheWriterFactory.create();
        }
        this.evictionTaskFuture = nodeEngine.getExecutionService().scheduleWithFixedDelay("hz:cache", new EvictionTask(), 5L, 5L, TimeUnit.SECONDS);
        this.cacheRecordFactory = new CacheRecordFactory(this.cacheConfig.getInMemoryFormat(), nodeEngine.getSerializationService());
        Factory expiryPolicyFactory = this.cacheConfig.getExpiryPolicyFactory();
        this.defaultExpiryPolicy = (ExpiryPolicy)expiryPolicyFactory.create();
    }

    @Override
    public Object get(Data key, ExpiryPolicy expiryPolicy) {
        ExpiryPolicy localExpiryPolicy = expiryPolicy != null ? expiryPolicy : this.defaultExpiryPolicy;
        long now = Clock.currentTimeMillis();
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        if (record == null || isExpired) {
            Object value;
            if (this.isStatisticsEnabled()) {
                this.statistics.increaseCacheMisses(1L);
            }
            if ((value = this.readThroughCache(key)) == null) {
                return null;
            }
            this.createRecordWithExpiry(key, value, localExpiryPolicy, now, true);
            return value;
        }
        Object value = record.getValue();
        this.updateAccessDuration(record, localExpiryPolicy, now);
        if (this.isStatisticsEnabled()) {
            this.statistics.increaseCacheHits(1L);
        }
        return value;
    }

    @Override
    public void put(Data key, Object value, ExpiryPolicy expiryPolicy, String caller) {
        this.getAndPut(key, value, expiryPolicy, caller, false, false);
    }

    protected Object getAndPut(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, boolean getValue, boolean disableWriteThrough) {
        boolean isPutSucceed;
        ExpiryPolicy localExpiryPolicy = expiryPolicy != null ? expiryPolicy : this.defaultExpiryPolicy;
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        Object oldValue = null;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        if (record == null || isExpired) {
            isPutSucceed = this.createRecordWithExpiry(key, value, localExpiryPolicy, now, disableWriteThrough);
        } else {
            oldValue = record.getValue();
            isPutSucceed = this.updateRecordWithExpiry(key, value, record, localExpiryPolicy, now, disableWriteThrough);
        }
        this.updateGetAndPutStat(isPutSucceed, getValue, oldValue == null, start);
        return oldValue;
    }

    private void updateGetAndPutStat(boolean isPutSucceed, boolean getValue, boolean oldValueNull, long start) {
        if (this.isStatisticsEnabled()) {
            if (isPutSucceed) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            }
            if (getValue) {
                if (oldValueNull) {
                    this.statistics.increaseCacheMisses(1L);
                } else {
                    this.statistics.increaseCacheHits(1L);
                }
                this.statistics.addGetTimeNano(System.nanoTime() - start);
            }
        }
    }

    protected Object getAndPut(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, boolean getValue) {
        return this.getAndPut(key, value, expiryPolicy, caller, getValue, false);
    }

    @Override
    public Object getAndPut(Data key, Object value, ExpiryPolicy expiryPolicy, String caller) {
        return this.getAndPut(key, value, expiryPolicy, caller, true, false);
    }

    @Override
    public boolean putIfAbsent(Data key, Object value, ExpiryPolicy expiryPolicy, String caller) {
        return this.putIfAbsent(key, value, expiryPolicy, caller, false);
    }

    protected boolean putIfAbsent(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, boolean disableWriteThrough) {
        ExpiryPolicy localExpiryPolicy = expiryPolicy != null ? expiryPolicy : this.defaultExpiryPolicy;
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        boolean result = record == null || isExpired ? this.createRecordWithExpiry(key, value, localExpiryPolicy, now, disableWriteThrough) : false;
        if (result && this.isStatisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    @Override
    public Object getAndRemove(Data key, String caller) {
        Object result;
        boolean isExpired;
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        this.deleteCacheEntry(key);
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean bl = isExpired = record != null && record.isExpiredAt(now);
        if (record == null || isExpired) {
            result = null;
        } else {
            result = record.getValue();
            this.deleteRecord(key);
        }
        if (this.isStatisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (result != null) {
                this.statistics.increaseCacheHits(1L);
                this.statistics.increaseCacheRemovals(1L);
                this.statistics.addRemoveTimeNano(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    @Override
    public boolean remove(Data key, String caller) {
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        this.deleteCacheEntry(key);
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        boolean result = true;
        if (record == null || isExpired) {
            result = false;
        } else {
            this.deleteRecord(key);
        }
        if (result && this.isStatisticsEnabled()) {
            this.statistics.increaseCacheRemovals(1L);
            this.statistics.addRemoveTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    @Override
    public boolean remove(Data key, Object value, String caller) {
        ExpiryPolicy localExpiryPolicy = this.defaultExpiryPolicy;
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        int hitCount = 0;
        boolean result = true;
        if (record == null || isExpired) {
            if (this.isStatisticsEnabled()) {
                this.statistics.increaseCacheMisses(1L);
            }
            result = false;
        } else {
            ++hitCount;
            if (this.compare(record.getValue(), value)) {
                this.deleteCacheEntry(key);
                this.deleteRecord(key);
            } else {
                long expiryTime = this.updateAccessDuration(record, localExpiryPolicy, now);
                this.processExpiredEntry(key, record, expiryTime, now);
                result = false;
            }
        }
        if (result && this.isStatisticsEnabled()) {
            this.statistics.increaseCacheRemovals(1L);
            this.statistics.addRemoveTimeNano(System.nanoTime() - start);
            if (hitCount == 1) {
                this.statistics.increaseCacheHits(hitCount);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    private long updateAccessDuration(CacheRecord record, ExpiryPolicy localExpiryPolicy, long now) {
        long expiryTime = -1L;
        try {
            Duration expiryDuration = localExpiryPolicy.getExpiryForAccess();
            if (expiryDuration != null) {
                expiryTime = expiryDuration.getAdjustedTime(now);
                record.setExpirationTime(expiryTime);
            }
        }
        catch (Exception e) {
            EmptyStatement.ignore(e);
        }
        return expiryTime;
    }

    @Override
    public boolean replace(Data key, Object value, ExpiryPolicy expiryPolicy, String caller) {
        ExpiryPolicy localExpiryPolicy = expiryPolicy != null ? expiryPolicy : this.defaultExpiryPolicy;
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        boolean result = record == null || isExpired ? false : this.updateRecordWithExpiry(key, value, record, localExpiryPolicy, now, false);
        if (this.isStatisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (result) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.increaseCacheHits(1L);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    @Override
    public boolean replace(Data key, Object oldValue, Object newValue, ExpiryPolicy expiryPolicy, String caller) {
        boolean result;
        boolean isExpired;
        ExpiryPolicy localExpiryPolicy = expiryPolicy != null ? expiryPolicy : this.defaultExpiryPolicy;
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        boolean isHit = false;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean bl = isExpired = record != null && record.isExpiredAt(now);
        if (record == null || isExpired) {
            result = false;
        } else {
            isHit = true;
            Object value = record.getValue();
            if (this.compare(value, oldValue)) {
                result = this.updateRecordWithExpiry(key, newValue, record, localExpiryPolicy, now, false);
            } else {
                this.updateAccessDuration(record, localExpiryPolicy, now);
                result = false;
            }
        }
        this.updateReplaceStat(result, isHit, start);
        return result;
    }

    private void updateReplaceStat(boolean result, boolean isHit, long start) {
        if (this.isStatisticsEnabled()) {
            if (result) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            }
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (isHit) {
                this.statistics.increaseCacheHits(1L);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
    }

    @Override
    public Object getAndReplace(Data key, Object value, ExpiryPolicy expiryPolicy, String caller) {
        boolean isExpired;
        ExpiryPolicy localExpiryPolicy = expiryPolicy != null ? expiryPolicy : this.defaultExpiryPolicy;
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        Object result = null;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean bl = isExpired = record != null && record.isExpiredAt(now);
        if (record == null || isExpired) {
            result = null;
        } else {
            result = record.getValue();
            this.updateRecordWithExpiry(key, value, record, localExpiryPolicy, now, false);
        }
        if (this.isStatisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (result != null) {
                this.statistics.increaseCacheHits(1L);
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    @Override
    public boolean contains(Data key) {
        long now = Clock.currentTimeMillis();
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        return record != null && !isExpired;
    }

    @Override
    public MapEntrySet getAll(Set<Data> keySet, ExpiryPolicy expiryPolicy) {
        ExpiryPolicy localExpiryPolicy = expiryPolicy != null ? expiryPolicy : this.defaultExpiryPolicy;
        MapEntrySet result = new MapEntrySet();
        for (Data key : keySet) {
            Object value = this.get(key, localExpiryPolicy);
            if (value == null) continue;
            result.add(key, this.cacheService.toData(value));
        }
        return result;
    }

    @Override
    public int size() {
        return this.records.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(Set<Data> keys, boolean isRemoveAll) {
        HashSet<Data> keysToClean;
        if (!isRemoveAll) {
            this.records.clear();
            return;
        }
        long now = Clock.currentTimeMillis();
        HashSet<Data> localKeys = new HashSet<Data>(keys.isEmpty() ? this.records.keySet() : keys);
        try {
            this.deleteAllCacheEntry(localKeys);
            keysToClean = new HashSet<Data>(keys.isEmpty() ? this.records.keySet() : keys);
        }
        catch (Throwable throwable) {
            HashSet<Data> keysToClean2 = new HashSet<Data>(keys.isEmpty() ? this.records.keySet() : keys);
            for (Data key : keysToClean2) {
                this.isEventBatchingEnabled = true;
                CacheRecord record = (CacheRecord)this.records.get(key);
                if (localKeys.contains(key) && record != null) {
                    boolean isExpired = this.processExpiredEntry(key, record, now);
                    if (!isExpired) {
                        this.deleteRecord(key);
                        if (this.isStatisticsEnabled()) {
                            this.statistics.increaseCacheRemovals(1L);
                        }
                    }
                } else {
                    keys.remove(key);
                }
                this.isEventBatchingEnabled = false;
                int orderKey = keys.hashCode();
                this.publishBatchedEvents(this.name, CacheEventType.REMOVED, orderKey);
            }
            throw throwable;
        }
        for (Data key : keysToClean) {
            this.isEventBatchingEnabled = true;
            CacheRecord record = (CacheRecord)this.records.get(key);
            if (localKeys.contains(key) && record != null) {
                boolean isExpired = this.processExpiredEntry(key, record, now);
                if (!isExpired) {
                    this.deleteRecord(key);
                    if (this.isStatisticsEnabled()) {
                        this.statistics.increaseCacheRemovals(1L);
                    }
                }
            } else {
                keys.remove(key);
            }
            this.isEventBatchingEnabled = false;
            int orderKey = keys.hashCode();
            this.publishBatchedEvents(this.name, CacheEventType.REMOVED, orderKey);
        }
    }

    @Override
    public void destroy() {
        this.clear(null, false);
        this.onDestroy();
        this.closeResources();
        EventService eventService = this.cacheService.getNodeEngine().getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", this.name);
        for (EventRegistration registration : candidates) {
            if (!(((EventServiceImpl.Registration)registration).getListener() instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)registration)).close();
            }
            catch (IOException e) {
                EmptyStatement.ignore(e);
            }
        }
    }

    private void closeResources() {
        if (this.cacheWriter instanceof Closeable) {
            IOUtil.closeResource((Closeable)this.cacheWriter);
        }
        if (this.cacheLoader instanceof Closeable) {
            IOUtil.closeResource((Closeable)this.cacheLoader);
        }
        if (this.defaultExpiryPolicy instanceof Closeable) {
            IOUtil.closeResource((Closeable)this.defaultExpiryPolicy);
        }
    }

    public void onDestroy() {
        ScheduledFuture<?> f = this.evictionTaskFuture;
        if (f != null) {
            f.cancel(true);
        }
    }

    @Override
    public CacheRecord getRecord(Data key) {
        return (CacheRecord)this.records.get(key);
    }

    @Override
    public void setRecord(Data key, CacheRecord record) {
        if (key != null && record != null) {
            this.records.put(key, record);
        }
    }

    @Override
    public CacheRecord removeRecord(Data key) {
        if (key != null) {
            return (CacheRecord)this.records.remove(key);
        }
        return null;
    }

    @Override
    public CacheKeyIteratorResult iterator(int tableIndex, int size) {
        return this.records.fetchNext(tableIndex, size);
    }

    @Override
    public Object invoke(Data key, EntryProcessor entryProcessor, Object[] arguments) {
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        if (isExpired) {
            record = null;
        }
        if (this.isStatisticsEnabled()) {
            if (record == null || isExpired) {
                this.statistics.increaseCacheMisses(1L);
            } else {
                this.statistics.increaseCacheHits(1L);
            }
        }
        if (this.isStatisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
        }
        CacheEntryProcessorEntry entry = new CacheEntryProcessorEntry(key, record, this, now);
        Object process = entryProcessor.process(entry, arguments);
        entry.applyChanges();
        return process;
    }

    @Override
    public Set<Data> loadAll(Set<Data> keys, boolean replaceExistingValues) {
        HashSet<Data> keysLoaded = new HashSet<Data>();
        Map<Data, Object> loaded = this.loadAllCacheEntry(keys);
        if (loaded == null || loaded.isEmpty()) {
            return keysLoaded;
        }
        if (replaceExistingValues) {
            for (Map.Entry<Data, Object> entry : loaded.entrySet()) {
                Data key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                this.getAndPut(key, value, null, null, false, true);
                keysLoaded.add(key);
            }
        } else {
            for (Map.Entry<Data, Object> entry : loaded.entrySet()) {
                boolean hasPut;
                Data key = entry.getKey();
                Object value = entry.getValue();
                if (value == null || !(hasPut = this.putIfAbsent(key, value, null, null, true))) continue;
                keysLoaded.add(key);
            }
        }
        return keysLoaded;
    }

    @Override
    public CacheStatisticsImpl getCacheStats() {
        return this.statistics;
    }

    @Override
    public CacheConfig getConfig() {
        return this.cacheConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<Data, CacheRecord> getReadOnlyRecords() {
        return Collections.unmodifiableMap(this.records);
    }

    public void evictExpiredRecords() {
    }

    boolean createRecordWithExpiry(Data key, Object value, ExpiryPolicy localExpiryPolicy, long now, boolean disableWriteThrough) {
        Duration expiryDuration;
        try {
            expiryDuration = localExpiryPolicy.getExpiryForCreation();
        }
        catch (Exception e) {
            expiryDuration = Duration.ETERNAL;
        }
        long expiryTime = expiryDuration.getAdjustedTime(now);
        if (!disableWriteThrough) {
            this.writeThroughCache(key, value);
        }
        if (!CacheRecordFactory.isExpiredAt(expiryTime, now)) {
            CacheRecord record = this.createRecord(key, value, expiryTime);
            this.records.put(key, record);
            return true;
        }
        return false;
    }

    private CacheRecord createRecord(Data keyData, Object value, long expirationTime) {
        CacheRecord record = this.cacheRecordFactory.newRecordWithExpiry(keyData, value, expirationTime);
        if (this.isEventsEnabled) {
            Object recordValue = record.getValue();
            Data dataValue = !(recordValue instanceof Data) ? this.cacheService.toData(recordValue) : (Data)recordValue;
            this.publishEvent(this.name, CacheEventType.CREATED, record.getKey(), null, dataValue, false);
        }
        return record;
    }

    boolean updateRecordWithExpiry(Data key, Object value, CacheRecord record, ExpiryPolicy localExpiryPolicy, long now, boolean disableWriteThrough) {
        long expiryTime = -1L;
        try {
            Duration expiryDuration = localExpiryPolicy.getExpiryForUpdate();
            if (expiryDuration != null) {
                expiryTime = expiryDuration.getAdjustedTime(now);
                record.setExpirationTime(expiryTime);
            }
        }
        catch (Exception e) {
            EmptyStatement.ignore(e);
        }
        if (!disableWriteThrough) {
            this.writeThroughCache(key, value);
        }
        this.updateRecord(record, value);
        return !this.processExpiredEntry(key, record, expiryTime, now);
    }

    private CacheRecord updateRecord(CacheRecord record, Object value) {
        Data dataOldValue;
        Data dataValue;
        Object v = value;
        switch (this.cacheConfig.getInMemoryFormat()) {
            case BINARY: {
                if (!(value instanceof Data)) {
                    v = this.cacheService.toData(value);
                }
                dataValue = (Data)v;
                dataOldValue = (Data)record.getValue();
                break;
            }
            case OBJECT: {
                if (value instanceof Data) {
                    v = this.cacheService.toObject(value);
                    dataValue = (Data)value;
                } else {
                    dataValue = this.cacheService.toData(value);
                }
                dataOldValue = this.cacheService.toData(record.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.cacheConfig.getInMemoryFormat()));
            }
        }
        record.setValue(v);
        if (this.isEventsEnabled) {
            this.publishEvent(this.name, CacheEventType.UPDATED, record.getKey(), dataOldValue, dataValue, true);
        }
        return record;
    }

    void deleteRecord(Data key) {
        Data dataValue;
        CacheRecord record = (CacheRecord)this.records.remove(key);
        switch (this.cacheConfig.getInMemoryFormat()) {
            case BINARY: {
                dataValue = (Data)record.getValue();
                break;
            }
            case OBJECT: {
                dataValue = this.cacheService.toData(record.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.cacheConfig.getInMemoryFormat()));
            }
        }
        if (this.isEventsEnabled) {
            this.publishEvent(this.name, CacheEventType.REMOVED, record.getKey(), null, dataValue, false);
        }
    }

    CacheRecord accessRecord(CacheRecord record, ExpiryPolicy expiryPolicy, long now) {
        ExpiryPolicy localExpiryPolicy = expiryPolicy != null ? expiryPolicy : this.defaultExpiryPolicy;
        this.updateAccessDuration(record, localExpiryPolicy, now);
        return record;
    }

    CacheRecord readThroughRecord(Data key, long now) {
        Duration expiryDuration;
        ExpiryPolicy localExpiryPolicy = this.defaultExpiryPolicy;
        Object value = this.readThroughCache(key);
        if (value == null) {
            return null;
        }
        try {
            expiryDuration = localExpiryPolicy.getExpiryForCreation();
        }
        catch (Exception e) {
            expiryDuration = Duration.ETERNAL;
        }
        long expiryTime = expiryDuration.getAdjustedTime(now);
        if (CacheRecordFactory.isExpiredAt(expiryTime, now)) {
            return null;
        }
        CacheRecord record = this.createRecord(key, value, expiryTime);
        return record;
    }

    protected Object readThroughCache(Data key) throws CacheLoaderException {
        if (this.isReadThrough() && this.cacheLoader != null) {
            try {
                Object o = this.cacheService.toObject(key);
                return this.cacheLoader.load(o);
            }
            catch (Exception e) {
                if (!(e instanceof CacheLoaderException)) {
                    throw new CacheLoaderException("Exception in CacheLoader during load", (Throwable)e);
                }
                throw (CacheLoaderException)e;
            }
        }
        return null;
    }

    protected void writeThroughCache(Data key, Object value) throws CacheWriterException {
        if (this.isWriteThrough() && this.cacheWriter != null) {
            try {
                Object objValue;
                Object objKey = this.cacheService.toObject(key);
                switch (this.cacheConfig.getInMemoryFormat()) {
                    case BINARY: {
                        objValue = this.cacheService.toObject(value);
                        break;
                    }
                    case OBJECT: {
                        objValue = value;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.cacheConfig.getInMemoryFormat()));
                    }
                }
                CacheEntry<Object, Object> entry = new CacheEntry<Object, Object>(objKey, objValue);
                this.cacheWriter.write(entry);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter during write", (Throwable)e);
                }
                throw (CacheWriterException)e;
            }
        }
    }

    protected void deleteCacheEntry(Data key) {
        if (this.isWriteThrough() && this.cacheWriter != null) {
            try {
                Object objKey = this.cacheService.toObject(key);
                this.cacheWriter.delete(objKey);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter during delete", (Throwable)e);
                }
                throw (CacheWriterException)e;
            }
        }
    }

    protected void deleteAllCacheEntry(Set<Data> keys) {
        if (this.isWriteThrough() && this.cacheWriter != null && keys != null && !keys.isEmpty()) {
            HashMap<Object, Data> keysToDelete = new HashMap<Object, Data>();
            for (Data key : keys) {
                Object localKeyObj = this.cacheService.toObject(key);
                keysToDelete.put(localKeyObj, key);
            }
            Set keysObject = keysToDelete.keySet();
            try {
                this.cacheWriter.deleteAll(keysObject);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter during deleteAll", (Throwable)e);
                }
                throw (CacheWriterException)e;
            }
            finally {
                for (Object undeletedKey : keysObject) {
                    Data undeletedKeyData = (Data)keysToDelete.get(undeletedKey);
                    keys.remove(undeletedKeyData);
                }
            }
        }
    }

    protected Map<Data, Object> loadAllCacheEntry(Set<Data> keys) {
        if (this.cacheLoader != null) {
            Map loaded;
            HashMap<Object, Data> keysToLoad = new HashMap<Object, Data>();
            for (Data key : keys) {
                Object localKeyObj = this.cacheService.toObject(key);
                keysToLoad.put(localKeyObj, key);
            }
            try {
                loaded = this.cacheLoader.loadAll(keysToLoad.keySet());
            }
            catch (Throwable e) {
                if (!(e instanceof CacheLoaderException)) {
                    throw new CacheLoaderException("Exception in CacheLoader during loadAll", e);
                }
                throw (CacheLoaderException)e;
            }
            HashMap<Data, Object> result = new HashMap<Data, Object>();
            for (Map.Entry entry : keysToLoad.entrySet()) {
                Object keyObj = entry.getKey();
                Object valueObject = loaded.get(keyObj);
                Data keyData = (Data)entry.getValue();
                result.put(keyData, valueObject);
            }
            return result;
        }
        return null;
    }

    protected boolean processExpiredEntry(Data key, CacheRecord record, long now) {
        boolean isExpired;
        boolean bl = isExpired = record != null && record.isExpiredAt(now);
        if (!isExpired) {
            return false;
        }
        this.records.remove(key);
        if (this.isEventsEnabled) {
            Data dataValue;
            switch (this.cacheConfig.getInMemoryFormat()) {
                case BINARY: {
                    dataValue = (Data)record.getValue();
                    break;
                }
                case OBJECT: {
                    dataValue = this.cacheService.toData(record.getValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.cacheConfig.getInMemoryFormat()));
                }
            }
            this.publishEvent(this.name, CacheEventType.EXPIRED, key, null, dataValue, false);
        }
        return true;
    }

    protected boolean processExpiredEntry(Data key, CacheRecord record, long expiryTime, long now) {
        boolean isExpired = CacheRecordFactory.isExpiredAt(expiryTime, now);
        if (!isExpired) {
            return false;
        }
        if (this.isStatisticsEnabled()) {
            this.statistics.increaseCacheExpiries(1L);
        }
        this.records.remove(key);
        if (this.isEventsEnabled) {
            Data dataValue;
            switch (this.cacheConfig.getInMemoryFormat()) {
                case BINARY: {
                    dataValue = (Data)record.getValue();
                    break;
                }
                case OBJECT: {
                    dataValue = this.cacheService.toData(record.getValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.cacheConfig.getInMemoryFormat()));
                }
            }
            this.publishEvent(this.name, CacheEventType.EXPIRED, key, null, dataValue, false);
        }
        return true;
    }

    @Override
    public void publishCompletedEvent(String cacheName, int completionId, Data dataKey, int orderKey) {
        if (completionId > 0) {
            this.cacheService.publishEvent(cacheName, CacheEventType.COMPLETED, dataKey, this.cacheService.toData(completionId), null, false, orderKey);
        }
    }

    protected void publishEvent(String cacheName, CacheEventType eventType, Data dataKey, Data dataOldValue, Data dataValue, boolean isOldValueAvailable) {
        if (this.isEventBatchingEnabled) {
            CacheEventDataImpl cacheEventData = new CacheEventDataImpl(cacheName, eventType, dataKey, dataValue, dataOldValue, isOldValueAvailable);
            Set<CacheEventData> cacheEventDatas = this.batchEvent.get((Object)eventType);
            if (cacheEventDatas == null) {
                cacheEventDatas = new HashSet<CacheEventData>();
                this.batchEvent.put(eventType, cacheEventDatas);
            }
            cacheEventDatas.add(cacheEventData);
        } else {
            this.cacheService.publishEvent(cacheName, eventType, dataKey, dataValue, dataOldValue, isOldValueAvailable, dataKey.hashCode());
        }
    }

    private void publishBatchedEvents(String cacheName, CacheEventType cacheEventType, int orderKey) {
        Set<CacheEventData> cacheEventDatas = this.batchEvent.get((Object)cacheEventType);
        CacheEventSet ces = new CacheEventSet(cacheEventType, cacheEventDatas);
        this.cacheService.publishEvent(cacheName, ces, orderKey);
    }

    private boolean compare(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        if (v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    private boolean isReadThrough() {
        return this.cacheConfig.isReadThrough();
    }

    private boolean isWriteThrough() {
        return this.cacheConfig.isWriteThrough();
    }

    private boolean isStatisticsEnabled() {
        if (!this.cacheConfig.isStatisticsEnabled()) {
            return false;
        }
        if (this.statistics == null) {
            this.statistics = this.cacheService.createCacheStatIfAbsent(this.name);
        }
        return true;
    }

    private class EvictionTask
    implements Runnable {
        private EvictionTask() {
        }

        @Override
        public void run() {
            if (CacheRecordStore.this.hasExpiringEntry) {
                CacheRecordStore.this.evictExpiredRecords();
            }
        }
    }
}

