/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cloud.maven.client;

import com.hazelcast.cloud.maven.auth.AuthUtils;
import com.hazelcast.cloud.maven.model.Cluster;
import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.netty.http.client.HttpClient;

public class HazelcastCloudClient {
    private final String apiBaseUrl;
    private final String token;
    private final RestTemplate restTemplate = new RestTemplate();

    public HazelcastCloudClient(String apiBaseUrl, String token) {
        this.apiBaseUrl = apiBaseUrl;
        this.token = token;
    }

    public Cluster getClusterStatus(String clusterId) {
        return (Cluster)this.restTemplate.exchange(this.url("/cluster/{clusterId}"), HttpMethod.GET, new HttpEntity((MultiValueMap)AuthUtils.headersWithAuth(this.token)), Cluster.class, new Object[]{clusterId}).getBody();
    }

    public Flux<ServerSentEvent<String>> getClusterLogs(String clusterId) {
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(HttpClient.create().responseTimeout(Duration.ofMinutes(5L)))).baseUrl(String.format("%s/cluster/%s/logstream", this.apiBaseUrl, clusterId)).build().get().header("Authorization", new String[]{"Bearer " + this.token}).retrieve().bodyToFlux((ParameterizedTypeReference)new ParameterizedTypeReference<ServerSentEvent<String>>(){});
    }

    public void uploadCustomClasses(String clusterId, File file) {
        HttpHeaders headers = AuthUtils.headersWithAuth(this.token);
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"customClassesFile", (Object)new FileSystemResource(file));
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("clusterId", clusterId);
        this.restTemplate.postForEntity(this.url("/cluster/{clusterId}/custom_classes"), (Object)new HttpEntity((Object)body, (MultiValueMap)headers), String.class, pathParams);
    }

    private String url(String uri) {
        return this.apiBaseUrl + uri;
    }
}

