/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cloud.maven.auth;

import com.hazelcast.cloud.maven.model.CustomerApiLogin;
import com.hazelcast.cloud.maven.model.CustomerTokenResponse;
import org.springframework.web.client.RestTemplate;

public final class ApiAuthenticator {
    private static final RestTemplate HTTP_CLIENT = new RestTemplate();
    private static volatile String TOKEN_INSTANCE;

    public static synchronized String getToken(String baseURL, String apiKey, String apiSecret) {
        if (TOKEN_INSTANCE != null) {
            return TOKEN_INSTANCE;
        }
        TOKEN_INSTANCE = ApiAuthenticator.login(baseURL, apiKey, apiSecret);
        return TOKEN_INSTANCE;
    }

    private static String login(String baseURL, String apiKey, String apiSecret) {
        CustomerApiLogin customerApiLogin = CustomerApiLogin.builder().apiKey(apiKey).apiSecret(apiSecret).build();
        return ((CustomerTokenResponse)HTTP_CLIENT.postForObject(baseURL + "/customers/api/login", (Object)customerApiLogin, CustomerTokenResponse.class, new Object[0])).getToken();
    }

    private ApiAuthenticator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

