/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cloud.maven;

import com.hazelcast.cloud.maven.auth.ApiAuthenticator;
import com.hazelcast.cloud.maven.client.HazelcastCloudClient;
import com.hazelcast.cloud.maven.validation.Errors;
import java.util.function.Supplier;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.http.codec.ServerSentEvent;

@Mojo(name="stream-logs", defaultPhase=LifecyclePhase.INITIALIZE)
public class LogsHandler
extends AbstractMojo {
    @Parameter(property="apiBaseUrl", required=true)
    private String apiBaseUrl;
    @Parameter(property="clusterId", required=true)
    private String clusterId;
    @Parameter(property="apiKey", required=true)
    private String apiKey;
    @Parameter(property="apiSecret", required=true)
    private String apiSecret;
    private Supplier<HazelcastCloudClient> hazelcastCloudClientSupplier = () -> new HazelcastCloudClient(this.apiBaseUrl, ApiAuthenticator.getToken(this.apiBaseUrl, this.apiKey, this.apiSecret));

    public void execute() throws MojoExecutionException {
        this.validateParams();
        this.hazelcastCloudClientSupplier.get().getClusterLogs(this.clusterId).mapNotNull(ServerSentEvent::data).toStream().forEach(System.out::println);
    }

    public void validateParams() throws MojoExecutionException {
        if (StringUtils.isEmpty((String)this.apiBaseUrl)) {
            Errors.propertyMissingError("apiBaseUrl");
        }
        if (StringUtils.isEmpty((String)this.clusterId)) {
            Errors.propertyMissingError("clusterId");
        }
        if (StringUtils.isEmpty((String)this.apiKey)) {
            Errors.propertyMissingError("apiKey");
        }
        if (StringUtils.isEmpty((String)this.apiSecret)) {
            Errors.propertyMissingError("apiSecret");
        }
    }

    public void setApiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public void setHazelcastCloudClientSupplier(Supplier<HazelcastCloudClient> hazelcastCloudClientSupplier) {
        this.hazelcastCloudClientSupplier = hazelcastCloudClientSupplier;
    }
}

