/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cloud.maven;

import com.hazelcast.cloud.maven.auth.ApiAuthenticator;
import com.hazelcast.cloud.maven.client.HazelcastCloudClient;
import com.hazelcast.cloud.maven.exception.ClusterFailureException;
import com.hazelcast.cloud.maven.validation.Errors;
import java.io.File;
import java.util.function.Supplier;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.retry.support.RetryTemplateBuilder;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployHandler
extends AbstractMojo {
    @Parameter(property="apiBaseUrl", defaultValue="https://api.viridian.hazelcast.com")
    private String apiBaseUrl;
    @Parameter(property="clusterId", required=true)
    private String clusterId;
    @Parameter(property="apiKey", required=true)
    private String apiKey;
    @Parameter(property="apiSecret", required=true)
    private String apiSecret;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    private Supplier<HazelcastCloudClient> hazelcastCloudClientSupplier = () -> new HazelcastCloudClient(this.apiBaseUrl, ApiAuthenticator.getToken(this.apiBaseUrl, this.apiKey, this.apiSecret));

    public void execute() throws MojoExecutionException, MojoFailureException {
        long startTime = System.currentTimeMillis();
        this.validateParams();
        HazelcastCloudClient hazelcastCloudClient = this.hazelcastCloudClientSupplier.get();
        File jar = this.project.getArtifact().getFile();
        this.getLog().info((CharSequence)String.format("Artifact with custom classes %s is being uploaded to the Hazelcast cluster '%s'", jar, this.clusterId));
        hazelcastCloudClient.uploadCustomClasses(this.clusterId, jar);
        try {
            new RetryTemplateBuilder().withinMillis(300000L).fixedBackoff(1000L).retryOn(IllegalStateException.class).build().execute(retryContext -> {
                String state;
                long secs = (System.currentTimeMillis() - startTime) / 1000L;
                this.getLog().info((CharSequence)(secs + "s"));
                switch (state = hazelcastCloudClient.getClusterStatus((String)this.clusterId).state) {
                    case "RUNNING": {
                        return state;
                    }
                    case "FAILED": {
                        throw new ClusterFailureException(String.format("Something is wrong with cluster, state: %s", state));
                    }
                }
                throw new IllegalStateException(String.format("Something went wrong with uploading %s, state: %s", jar.getName(), state));
            });
            this.getLog().info((CharSequence)String.format("Artifact with custom classes %s was uploaded and is ready to be used", jar.getName()));
            float totalTimeSec = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            this.getLog().info((CharSequence)String.format("Artifact upload total time: %.3f s", Float.valueOf(totalTimeSec)));
        }
        catch (ClusterFailureException | IllegalStateException exception) {
            this.getLog().error((CharSequence)exception.getMessage());
            throw new MojoFailureException(exception.getMessage());
        }
    }

    public void validateParams() throws MojoExecutionException {
        if (StringUtils.isEmpty((String)this.apiBaseUrl)) {
            Errors.propertyMissingError("apiBaseUrl");
        }
        if (StringUtils.isEmpty((String)this.clusterId)) {
            Errors.propertyMissingError("clusterId");
        }
        if (StringUtils.isEmpty((String)this.apiKey)) {
            Errors.propertyMissingError("apiKey");
        }
        if (StringUtils.isEmpty((String)this.apiSecret)) {
            Errors.propertyMissingError("apiSecret");
        }
        if (this.project.getArtifact() == null || this.project.getArtifact().getFile() == null) {
            throw new MojoExecutionException("Project artifact (jar) is not packaged. Execute 'package' goal prior to 'deploy'.");
        }
    }

    public void setApiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setHazelcastCloudClientSupplier(Supplier<HazelcastCloudClient> hazelcastCloudClientSupplier) {
        this.hazelcastCloudClientSupplier = hazelcastCloudClientSupplier;
    }
}

