/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.stats;

import org.dataloader.stats.SimpleStatisticsCollector;
import org.dataloader.stats.Statistics;
import org.dataloader.stats.StatisticsCollector;
import org.dataloader.stats.context.IncrementBatchLoadCountByStatisticsContext;
import org.dataloader.stats.context.IncrementBatchLoadExceptionCountStatisticsContext;
import org.dataloader.stats.context.IncrementCacheHitCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadErrorCountStatisticsContext;

public class ThreadLocalStatisticsCollector
implements StatisticsCollector {
    private static final ThreadLocal<SimpleStatisticsCollector> collector = ThreadLocal.withInitial(SimpleStatisticsCollector::new);
    private final SimpleStatisticsCollector overallCollector = new SimpleStatisticsCollector();

    public ThreadLocalStatisticsCollector resetThread() {
        collector.remove();
        return this;
    }

    @Override
    public <K> void incrementLoadCount(IncrementLoadCountStatisticsContext<K> context) {
        this.overallCollector.incrementLoadCount(context);
        collector.get().incrementLoadCount(context);
    }

    @Override
    @Deprecated
    public void incrementLoadCount() {
        this.incrementLoadCount(null);
    }

    @Override
    public <K> void incrementLoadErrorCount(IncrementLoadErrorCountStatisticsContext<K> context) {
        this.overallCollector.incrementLoadErrorCount(context);
        collector.get().incrementLoadErrorCount(context);
    }

    @Override
    @Deprecated
    public void incrementLoadErrorCount() {
        this.incrementLoadErrorCount(null);
    }

    @Override
    public <K> void incrementBatchLoadCountBy(long delta, IncrementBatchLoadCountByStatisticsContext<K> context) {
        this.overallCollector.incrementBatchLoadCountBy(delta, context);
        collector.get().incrementBatchLoadCountBy(delta, context);
    }

    @Override
    @Deprecated
    public void incrementBatchLoadCountBy(long delta) {
        this.incrementBatchLoadCountBy(delta, null);
    }

    @Override
    public <K> void incrementBatchLoadExceptionCount(IncrementBatchLoadExceptionCountStatisticsContext<K> context) {
        this.overallCollector.incrementBatchLoadExceptionCount(context);
        collector.get().incrementBatchLoadExceptionCount(context);
    }

    @Override
    @Deprecated
    public void incrementBatchLoadExceptionCount() {
        this.incrementBatchLoadExceptionCount(null);
    }

    @Override
    public <K> void incrementCacheHitCount(IncrementCacheHitCountStatisticsContext<K> context) {
        this.overallCollector.incrementCacheHitCount(context);
        collector.get().incrementCacheHitCount(context);
    }

    @Override
    @Deprecated
    public void incrementCacheHitCount() {
        this.incrementCacheHitCount(null);
    }

    @Override
    public Statistics getStatistics() {
        return collector.get().getStatistics();
    }

    public Statistics getOverallStatistics() {
        return this.overallCollector.getStatistics();
    }

    public String toString() {
        return "ThreadLocalStatisticsCollector{thread=" + this.getStatistics().toString() + "overallCollector=" + this.overallCollector.getStatistics().toString() + "}";
    }
}

