/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.util;

import graphql.Internal;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

@Internal
public class DirectivesAndTypeWalker {
    private final Map<String, Boolean> seenTypes = new HashMap<String, Boolean>();

    public boolean isSuitable(GraphQLArgument argument, BiFunction<GraphQLInputType, GraphQLAppliedDirective, Boolean> isSuitable) {
        GraphQLInputType inputType = argument.getType();
        List directives = argument.getAppliedDirectives();
        return this.walkInputType(inputType, directives, isSuitable);
    }

    private boolean walkInputType(GraphQLInputType inputType, List<GraphQLAppliedDirective> directives, BiFunction<GraphQLInputType, GraphQLAppliedDirective, Boolean> isSuitable) {
        GraphQLInputType innerListType;
        String typeName = GraphQLTypeUtil.unwrapAll((GraphQLType)inputType).getName();
        GraphQLInputType unwrappedInputType = Util.unwrapNonNull(inputType);
        for (GraphQLAppliedDirective directive : directives) {
            if (!isSuitable.apply(unwrappedInputType, directive).booleanValue()) continue;
            return this.seen(typeName, true);
        }
        if (unwrappedInputType instanceof GraphQLInputObjectType) {
            GraphQLInputObjectType inputObjType = (GraphQLInputObjectType)unwrappedInputType;
            if (this.seenTypes.containsKey(typeName)) {
                return this.seenTypes.get(typeName);
            }
            this.seen(typeName, false);
            for (GraphQLInputObjectField inputField : inputObjType.getFieldDefinitions()) {
                inputType = inputField.getType();
                if (!this.walkInputType(inputType, directives = inputField.getAppliedDirectives(), isSuitable)) continue;
                return this.seen(typeName, true);
            }
        }
        if (unwrappedInputType instanceof GraphQLList && (innerListType = Util.unwrapOneAndAllNonNull(unwrappedInputType)) instanceof GraphQLDirectiveContainer && this.walkInputType(innerListType, directives = ((GraphQLDirectiveContainer)innerListType).getAppliedDirectives(), isSuitable)) {
            return this.seen(typeName, true);
        }
        return this.seen(typeName, false);
    }

    private boolean seen(String typeName, boolean flag) {
        this.seenTypes.put(typeName, flag);
        return flag;
    }
}

