/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.locale;

import graphql.Internal;
import graphql.schema.DataFetchingEnvironment;
import graphql.validation.locale.LocaleProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocaleUtil {
    private static final Map<Class, Method> METHOD_CACHE = new ConcurrentHashMap<Class, Method>();
    private static final Map<Class, Class> FAILED_CLASS_CACHE = new ConcurrentHashMap<Class, Class>();

    public static Locale determineLocale(DataFetchingEnvironment environment, Locale defaultLocale) {
        Locale locale = environment.getLocale();
        if (locale == null && (locale = LocaleUtil.extractLocale(environment.getContext())) == null && (locale = LocaleUtil.extractLocale(environment.getSource())) == null && (locale = LocaleUtil.extractLocale(environment.getRoot())) == null) {
            locale = defaultLocale;
        }
        return locale;
    }

    private static Locale extractLocale(Object object) {
        if (object != null) {
            if (object instanceof LocaleProvider) {
                return ((LocaleProvider)object).getLocale();
            }
            return LocaleUtil.reflectGetLocale(object);
        }
        return null;
    }

    @Internal
    public static void clearMethodCaches() {
        METHOD_CACHE.clear();
        FAILED_CLASS_CACHE.clear();
    }

    private static Locale reflectGetLocale(Object object) {
        Class<?> clazz = object.getClass();
        if (FAILED_CLASS_CACHE.containsKey(clazz)) {
            return null;
        }
        try {
            Method getLocaleMethod = METHOD_CACHE.get(clazz);
            if (getLocaleMethod == null) {
                getLocaleMethod = clazz.getMethod("getLocale", new Class[0]);
                if (Locale.class.equals(getLocaleMethod.getReturnType())) {
                    METHOD_CACHE.put(clazz, getLocaleMethod);
                } else {
                    getLocaleMethod = null;
                }
            }
            if (getLocaleMethod != null) {
                return (Locale)getLocaleMethod.invoke(object, new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        FAILED_CLASS_CACHE.put(clazz, clazz);
        return null;
    }
}

