/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints.standard;

import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.constraints.Documentation;
import graphql.validation.constraints.standard.AbstractNotEmptyRule;

public class ContainerNotEmptyConstraint
extends AbstractNotEmptyRule {
    public ContainerNotEmptyConstraint() {
        super("ContainerNotEmpty");
    }

    @Override
    public Documentation getDocumentation() {
        return Documentation.newDocumentation().messageTemplate(this.getMessageTemplate()).description("The container must have a non-zero size").example("updateAccident( accidentNotes : [Notes]! @ContainerNotEmpty) : DriverDetails").applicableTypeNames("Lists", "Input Objects").directiveSDL("directive @ContainerNotEmpty(message : String = \"%s\") on ARGUMENT_DEFINITION | INPUT_FIELD_DEFINITION", this.getMessageTemplate()).build();
    }

    @Override
    public boolean appliesToType(GraphQLInputType inputType) {
        return GraphQLTypeUtil.isList((GraphQLType)inputType) || this.isMap(inputType);
    }

    @Override
    protected boolean appliesToListElements() {
        return false;
    }
}

