/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.ExecutionResult;
import graphql.kickstart.execution.GraphQLQueryResult;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.servlet.BatchedQueryResponseWriter;
import graphql.kickstart.servlet.ErrorQueryResponseWriter;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.QueryResponseWriter;
import graphql.kickstart.servlet.QueryResponseWriterFactory;
import graphql.kickstart.servlet.SingleAsynchronousQueryResponseWriter;
import graphql.kickstart.servlet.SingleQueryResponseWriter;
import java.util.Objects;

public class QueryResponseWriterFactoryImpl
implements QueryResponseWriterFactory {
    @Override
    public QueryResponseWriter createWriter(GraphQLInvocationInput invocationInput, GraphQLQueryResult queryResult, GraphQLConfiguration configuration) {
        Objects.requireNonNull(queryResult, "GraphQL query result cannot be null");
        if (queryResult.isBatched()) {
            return new BatchedQueryResponseWriter(queryResult.getResults(), configuration.getObjectMapper());
        }
        if (queryResult.isAsynchronous()) {
            return new SingleAsynchronousQueryResponseWriter((ExecutionResult)queryResult.getResult(), configuration.getObjectMapper(), configuration.getSubscriptionTimeout());
        }
        if (queryResult.isError()) {
            return new ErrorQueryResponseWriter(queryResult.getStatusCode(), queryResult.getMessage());
        }
        return new SingleQueryResponseWriter((ExecutionResult)queryResult.getResult(), configuration.getObjectMapper());
    }
}

