/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.changefeed.util;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;

public class BoundedConcurrentStack<E>
implements Iterable<E> {
    private final Deque<E> elements = new ConcurrentLinkedDeque();
    private final int maxCapacity;

    public BoundedConcurrentStack(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public void push(E e) {
        while (this.elements.size() >= this.maxCapacity) {
            this.elements.removeLast();
        }
        this.elements.addFirst(e);
    }

    public void populate(Collection<E> elements) {
        this.elements.addAll(elements);
        while (this.elements.size() > this.maxCapacity) {
            this.elements.removeLast();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }
}

