/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.changefeed.io;

import com.graphaware.common.util.IterableUtils;
import com.graphaware.common.uuid.EaioUuidGenerator;
import com.graphaware.common.uuid.UuidGenerator;
import com.graphaware.module.changefeed.domain.ChangeSet;
import com.graphaware.module.changefeed.domain.Labels;
import com.graphaware.module.changefeed.domain.Relationships;
import com.graphaware.module.changefeed.io.ChangeWriter;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphChangeWriter
implements ChangeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(GraphChangeWriter.class);
    private final UuidGenerator uuidGenerator = new EaioUuidGenerator();
    private final GraphDatabaseService database;
    private final String moduleId;
    private Node root;

    public GraphChangeWriter(GraphDatabaseService database, String moduleId) {
        this.database = database;
        this.moduleId = moduleId;
    }

    @Override
    public void initialize() {
        this.root = this.getOrCreateRoot();
    }

    @Override
    public void recordChanges(Set<String> changes) {
        ChangeSet changeSet = new ChangeSet(this.uuidGenerator.generateUuid());
        changeSet.addChanges(changes);
        this.recordChanges(changeSet);
    }

    protected void recordChanges(ChangeSet changeSet) {
        try (Transaction tx = this.database.beginTx();){
            tx.acquireWriteLock((PropertyContainer)this.getRoot());
            Node changeNode = this.database.createNode(new Label[]{Labels._GA_ChangeSet});
            changeNode.setProperty("uuid", (Object)changeSet.getUuid());
            changeNode.setProperty("timestamp", (Object)changeSet.getTimestamp());
            changeNode.setProperty("changes", (Object)changeSet.getChangesAsArray());
            Relationship firstChangeRel = this.getRoot().getSingleRelationship((RelationshipType)Relationships._GA_CHANGEFEED_NEXT_CHANGE, Direction.OUTGOING);
            if (firstChangeRel == null) {
                this.getRoot().createRelationshipTo(changeNode, (RelationshipType)Relationships._GA_CHANGEFEED_OLDEST_CHANGE);
            } else {
                Node firstChange = firstChangeRel.getEndNode();
                tx.acquireWriteLock((PropertyContainer)firstChange);
                changeNode.createRelationshipTo(firstChange, (RelationshipType)Relationships._GA_CHANGEFEED_NEXT_CHANGE);
                firstChangeRel.delete();
            }
            this.getRoot().createRelationshipTo(changeNode, (RelationshipType)Relationships._GA_CHANGEFEED_NEXT_CHANGE);
            tx.success();
        }
    }

    @Override
    public void pruneChanges(int keep, int mustBeExceededBy) {
        try (Transaction tx = this.database.beginTx();){
            tx.acquireWriteLock((PropertyContainer)this.getRoot());
            Relationship oldestChangeRel = this.getRoot().getSingleRelationship((RelationshipType)Relationships._GA_CHANGEFEED_OLDEST_CHANGE, Direction.OUTGOING);
            if (oldestChangeRel != null) {
                Node oldestNode = oldestChangeRel.getEndNode();
                Node newestNode = this.getRoot().getSingleRelationship((RelationshipType)Relationships._GA_CHANGEFEED_NEXT_CHANGE, Direction.OUTGOING).getEndNode();
                if (newestNode != null) {
                    int exceededCount;
                    int changeCount;
                    Node lastNodeToKeep = newestNode;
                    Relationship nextRel = lastNodeToKeep.getSingleRelationship((RelationshipType)Relationships._GA_CHANGEFEED_NEXT_CHANGE, Direction.OUTGOING);
                    for (changeCount = 1; changeCount < keep && nextRel != null; ++changeCount) {
                        lastNodeToKeep = nextRel.getEndNode();
                        nextRel = lastNodeToKeep.getSingleRelationship((RelationshipType)Relationships._GA_CHANGEFEED_NEXT_CHANGE, Direction.OUTGOING);
                    }
                    if (changeCount < keep) {
                        LOG.debug("Nothing to prune");
                        tx.success();
                        return;
                    }
                    Relationship nextExceededByRel = nextRel;
                    for (exceededCount = 0; exceededCount < mustBeExceededBy && nextExceededByRel != null; ++exceededCount) {
                        nextExceededByRel = nextExceededByRel.getEndNode().getSingleRelationship((RelationshipType)Relationships._GA_CHANGEFEED_NEXT_CHANGE, Direction.OUTGOING);
                    }
                    if (exceededCount < mustBeExceededBy) {
                        LOG.debug("pruneWhenExceeded limit not exceeded, nothing to prune");
                        tx.success();
                        return;
                    }
                    LOG.debug("Preparing to prune change feed");
                    if (nextRel != null) {
                        nextRel.delete();
                        oldestChangeRel.delete();
                        this.getRoot().createRelationshipTo(lastNodeToKeep, (RelationshipType)Relationships._GA_CHANGEFEED_OLDEST_CHANGE);
                        Relationship previousChange = oldestNode.getSingleRelationship((RelationshipType)Relationships._GA_CHANGEFEED_NEXT_CHANGE, Direction.INCOMING);
                        while (previousChange != null) {
                            Node newOldestNode = previousChange.getStartNode();
                            previousChange.delete();
                            oldestNode.delete();
                            previousChange = newOldestNode.getSingleRelationship((RelationshipType)Relationships._GA_CHANGEFEED_NEXT_CHANGE, Direction.INCOMING);
                            oldestNode = newOldestNode;
                        }
                        oldestNode.delete();
                    }
                    LOG.debug("ChangeFeed pruning complete");
                }
            }
            tx.success();
        }
    }

    private Node getOrCreateRoot() {
        Node root;
        try (Transaction tx = this.database.beginTx();){
            root = (Node)IterableUtils.getSingleOrNull((Iterable)this.database.findNodesByLabelAndProperty((Label)Labels._GA_ChangeFeed, "moduleId", (Object)this.moduleId));
            if (root == null) {
                LOG.info("Creating the ChangeFeed Root for Module ID " + this.moduleId);
                root = this.database.createNode(new Label[]{Labels._GA_ChangeFeed});
                root.setProperty("moduleId", (Object)this.moduleId);
            }
            tx.success();
        }
        return root;
    }

    public Node getRoot() {
        if (this.root == null) {
            throw new IllegalStateException("There is no ChangeFeed Root for Module ID " + this.moduleId + "! This is a bug.");
        }
        return this.root;
    }
}

