/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.changefeed.io;

import com.graphaware.common.util.IterableUtils;
import com.graphaware.module.changefeed.domain.ChangeSet;
import com.graphaware.module.changefeed.domain.Labels;
import com.graphaware.module.changefeed.domain.Relationships;
import com.graphaware.module.changefeed.io.ChangeReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphChangeReader
implements ChangeReader {
    private static final Logger LOG = LoggerFactory.getLogger(GraphChangeReader.class);
    private final GraphDatabaseService database;
    private final Node root;

    public GraphChangeReader(GraphDatabaseService database) {
        this(database, "CFM");
    }

    public GraphChangeReader(GraphDatabaseService database, String moduleId) {
        this.database = database;
        try (Transaction tx = database.beginTx();){
            this.root = (Node)IterableUtils.getSingleOrNull((Iterator)database.findNodes((Label)Labels._GA_ChangeFeed, "moduleId", (Object)moduleId));
            if (this.root == null) {
                LOG.error("There is no ChangeFeed Root Node for module ID " + moduleId + "! Has the ChangeFeed Module been registered with the GraphAware Runtime? Has the Runtime been started?");
                throw new NotFoundException("There is no ChangeFeed Root Node for module ID " + moduleId + "! Has the ChangeFeed Module been registered with the GraphAware Runtime? Has the Runtime been started?");
            }
            tx.success();
        }
    }

    @Override
    public Collection<ChangeSet> getAllChanges() {
        return this.getChangesSince(null);
    }

    @Override
    public Collection<ChangeSet> getNumberOfChanges(int limit) {
        return this.getNumberOfChangesSince(null, limit);
    }

    @Override
    public Collection<ChangeSet> getChangesSince(String uuid) {
        return this.getNumberOfChangesSince(uuid, Integer.MAX_VALUE);
    }

    @Override
    public Collection<ChangeSet> getNumberOfChangesSince(String uuid, int limit) {
        return this.doGetChanges(uuid, limit);
    }

    protected Collection<ChangeSet> doGetChanges(String uuid, int limit) {
        ArrayList<ChangeSet> changeFeed = new ArrayList<ChangeSet>();
        try (Transaction tx = this.database.beginTx();){
            tx.acquireWriteLock((PropertyContainer)this.root);
            Relationship nextRel = this.root.getSingleRelationship((RelationshipType)Relationships._GA_CHANGEFEED_NEXT_CHANGE, Direction.OUTGOING);
            for (int count = 0; count < limit && nextRel != null; ++count) {
                Node changeNode = nextRel.getEndNode();
                ChangeSet changeSet = new ChangeSet((String)changeNode.getProperty("uuid"), (Long)changeNode.getProperty("timestamp"));
                if (uuid != null && changeSet.getUuid().equals(uuid)) break;
                changeSet.addChanges((String[])changeNode.getProperty("changes"));
                changeFeed.add(changeSet);
                nextRel = changeNode.getSingleRelationship((RelationshipType)Relationships._GA_CHANGEFEED_NEXT_CHANGE, Direction.OUTGOING);
            }
            tx.success();
        }
        return changeFeed;
    }
}

