/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.changefeed.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.graphaware.common.util.ArrayUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class ChangeSet {
    private final String uuid;
    private final long timestamp;
    private final List<String> changes = new LinkedList<String>();

    public ChangeSet(String uuid) {
        this(uuid, new Date().getTime());
    }

    public ChangeSet(String uuid, long timestamp) {
        this.uuid = uuid;
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void addChanges(Collection<String> changes) {
        this.changes.addAll(changes);
    }

    public void addChanges(String ... changes) {
        this.changes.addAll(Arrays.asList(changes));
    }

    public List<String> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    @JsonIgnore
    public String[] getChangesAsArray() {
        return this.changes.toArray(new String[this.changes.size()]);
    }

    public String toString() {
        return "ChangeSet{uuid='" + this.uuid + '\'' + ", timestamp=" + this.timestamp + ", changes=" + ArrayUtils.primitiveOrStringArrayToString((Object)this.getChangesAsArray()) + '}';
    }
}

