/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.changefeed.cache;

import com.graphaware.module.changefeed.cache.ChangeSetCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ChangeSetCacheRepository {
    private final Map<String, ChangeSetCache> caches = new ConcurrentHashMap<String, ChangeSetCache>();

    public void registerCache(String moduleId, ChangeSetCache cache) {
        this.caches.put(moduleId, cache);
    }

    public ChangeSetCache getCache(String moduleId) {
        if (!this.caches.containsKey(moduleId)) {
            throw new IllegalStateException("There is no change set cache for module ID " + moduleId + "." + " Please check that the module has been registered with GraphAware Runtime and that the Runtime has been started.");
        }
        return this.caches.get(moduleId);
    }

    public void clear() {
        this.caches.clear();
    }
}

