/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.changefeed.cache;

import com.graphaware.module.changefeed.domain.ChangeSet;
import com.graphaware.module.changefeed.util.BoundedConcurrentStack;
import java.util.Collection;
import java.util.LinkedList;

public class ChangeSetCache {
    private final BoundedConcurrentStack<ChangeSet> changes;

    public ChangeSetCache(int capacity) {
        this.changes = new BoundedConcurrentStack(capacity);
    }

    public void push(ChangeSet changeSet) {
        this.changes.push(changeSet);
    }

    public void populate(Collection<ChangeSet> changeSets) {
        this.changes.populate(changeSets);
    }

    public Collection<ChangeSet> getChanges(String uuid, int limit) {
        LinkedList<ChangeSet> result = new LinkedList<ChangeSet>();
        for (ChangeSet changeSet : this.changes) {
            if (uuid != null && uuid.equals(changeSet.getUuid())) break;
            result.add(changeSet);
            if (result.size() < limit) continue;
            return result;
        }
        return result;
    }
}

