/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.changefeed.api;

import com.graphaware.module.changefeed.cache.CachingGraphChangeReader;
import com.graphaware.module.changefeed.domain.ChangeSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/changefeed"})
public class ChangeFeedApi {
    private final GraphDatabaseService database;

    @Autowired
    public ChangeFeedApi(GraphDatabaseService database) {
        this.database = database;
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<ChangeSet> getChangeFeed(@RequestParam(value="uuid", required=false) String uuid, @RequestParam(value="limit", required=false) Integer limit) {
        return this.getChangeFeed("CFM", uuid, limit);
    }

    @RequestMapping(value={"/{moduleId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<ChangeSet> getChangeFeed(@PathVariable String moduleId, @RequestParam(value="uuid", required=false) String uuid, @RequestParam(value="limit", required=false) Integer limit) {
        CachingGraphChangeReader changeReader = new CachingGraphChangeReader(this.database, moduleId);
        if (uuid == null && limit == null) {
            return changeReader.getAllChanges();
        }
        if (uuid == null) {
            return changeReader.getNumberOfChanges(limit);
        }
        if (limit == null) {
            return changeReader.getChangesSince(uuid);
        }
        return changeReader.getNumberOfChangesSince(uuid, limit);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Map<String, String> handleIllegalArgument(IllegalArgumentException e) {
        return Collections.singletonMap("message", e.getMessage());
    }

    @ExceptionHandler(value={NotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Map<String, String> handleNotFound(NotFoundException e) {
        return Collections.singletonMap("message", e.getMessage());
    }
}

