/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.changefeed;

import com.graphaware.common.policy.NodeInclusionPolicy;
import com.graphaware.common.policy.NodePropertyInclusionPolicy;
import com.graphaware.common.policy.RelationshipInclusionPolicy;
import com.graphaware.common.policy.RelationshipPropertyInclusionPolicy;
import com.graphaware.module.changefeed.ChangeFeedConfiguration;
import com.graphaware.module.changefeed.ChangeFeedModule;
import com.graphaware.runtime.config.function.StringToNodeInclusionPolicy;
import com.graphaware.runtime.config.function.StringToNodePropertyInclusionPolicy;
import com.graphaware.runtime.config.function.StringToRelationshipInclusionPolicy;
import com.graphaware.runtime.config.function.StringToRelationshipPropertyInclusionPolicy;
import com.graphaware.runtime.module.RuntimeModule;
import com.graphaware.runtime.module.RuntimeModuleBootstrapper;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeFeedModuleBootstrapper
implements RuntimeModuleBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeFeedModuleBootstrapper.class);
    private static final String MAX_CHANGES = "maxChanges";
    private static final String PRUNE_DELAY = "pruneDelay";
    private static final String PRUNE_WHEN_EXCEEDED = "pruneWhenExceeded";
    private static final String NODE = "node";
    private static final String NODE_PROPERTY = "node.property";
    private static final String RELATIONSHIP = "relationship";
    private static final String RELATIONSHIP_PROPERTY = "relationship.property";

    public RuntimeModule bootstrapModule(String moduleId, Map<String, String> config, GraphDatabaseService database) {
        ChangeFeedConfiguration configuration = ChangeFeedConfiguration.defaultConfiguration();
        if (config.get(MAX_CHANGES) != null) {
            int maxChanges = Integer.parseInt(config.get(MAX_CHANGES));
            LOG.info("MaxChanges set to {}", (Object)maxChanges);
            configuration = configuration.withMaxChanges(maxChanges);
        }
        if (config.get(PRUNE_DELAY) != null) {
            int pruneDelay = Integer.parseInt(config.get(PRUNE_DELAY));
            LOG.info("PruneDelay set to {}", (Object)pruneDelay);
            configuration = configuration.withPruneDelay(pruneDelay);
        }
        if (config.get(PRUNE_WHEN_EXCEEDED) != null) {
            int pruneWhenExceeded = Integer.parseInt(config.get(PRUNE_WHEN_EXCEEDED));
            LOG.info("PruneWhenExceeded set to {}", (Object)pruneWhenExceeded);
            configuration = configuration.withPruneWhenMaxExceededBy(pruneWhenExceeded);
        }
        if (config.get(NODE) != null) {
            NodeInclusionPolicy policy = (NodeInclusionPolicy)StringToNodeInclusionPolicy.getInstance().apply(config.get(NODE));
            LOG.info("Node Inclusion Strategy set to {}", (Object)policy);
            configuration = (ChangeFeedConfiguration)configuration.with(policy);
        }
        if (config.get(NODE_PROPERTY) != null) {
            NodePropertyInclusionPolicy policy = (NodePropertyInclusionPolicy)StringToNodePropertyInclusionPolicy.getInstance().apply(config.get(NODE_PROPERTY));
            LOG.info("Node Property Inclusion Strategy set to {}", (Object)policy);
            configuration = (ChangeFeedConfiguration)configuration.with(policy);
        }
        if (config.get(RELATIONSHIP) != null) {
            RelationshipInclusionPolicy policy = (RelationshipInclusionPolicy)StringToRelationshipInclusionPolicy.getInstance().apply(config.get(RELATIONSHIP));
            LOG.info("Relationship Inclusion Strategy set to {}", (Object)policy);
            configuration = (ChangeFeedConfiguration)configuration.with(policy);
        }
        if (config.get(RELATIONSHIP_PROPERTY) != null) {
            RelationshipPropertyInclusionPolicy policy = (RelationshipPropertyInclusionPolicy)StringToRelationshipPropertyInclusionPolicy.getInstance().apply(config.get(RELATIONSHIP_PROPERTY));
            LOG.info("Relationship Property Inclusion Strategy set to {}", (Object)policy);
            configuration = (ChangeFeedConfiguration)configuration.with(policy);
        }
        return new ChangeFeedModule(moduleId, configuration, database);
    }
}

