/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.changefeed;

import com.graphaware.module.changefeed.ChangeFeedConfiguration;
import com.graphaware.module.changefeed.cache.CachingGraphChangeWriter;
import com.graphaware.module.changefeed.cache.ChangeSetCache;
import com.graphaware.module.changefeed.io.GraphChangeReader;
import com.graphaware.module.changefeed.io.GraphChangeWriter;
import com.graphaware.runtime.config.TxDrivenModuleConfiguration;
import com.graphaware.runtime.metadata.EmptyContext;
import com.graphaware.runtime.module.BaseTxDrivenModule;
import com.graphaware.runtime.module.DeliberateTransactionRollbackException;
import com.graphaware.runtime.module.TimerDrivenModule;
import com.graphaware.tx.event.improved.api.ImprovedTransactionData;
import org.neo4j.graphdb.GraphDatabaseService;

public class ChangeFeedModule
extends BaseTxDrivenModule<Void>
implements TimerDrivenModule<EmptyContext> {
    public static final String DEFAULT_MODULE_ID = "CFM";
    private final ChangeFeedConfiguration configuration;
    private final GraphChangeWriter changeWriter;
    private final ChangeSetCache changesCache;

    public ChangeFeedModule(String moduleId, ChangeFeedConfiguration configuration, GraphDatabaseService database) {
        super(moduleId);
        this.configuration = configuration;
        this.changesCache = new ChangeSetCache(configuration.getMaxChanges());
        this.changeWriter = new CachingGraphChangeWriter(database, moduleId, this.changesCache);
    }

    public void start(GraphDatabaseService database) {
        this.changeWriter.initialize();
        this.changesCache.populate(new GraphChangeReader(database, this.getId()).getAllChanges());
    }

    public TxDrivenModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public ChangeSetCache getChangesCache() {
        return this.changesCache;
    }

    public Void beforeCommit(ImprovedTransactionData transactionData) {
        if (transactionData.hasBeenDeleted(this.changeWriter.getRoot())) {
            throw new DeliberateTransactionRollbackException("Not allowed to delete change feed root!");
        }
        this.changeWriter.recordChanges(transactionData.mutationsToStrings());
        return null;
    }

    public EmptyContext createInitialContext(GraphDatabaseService database) {
        return new EmptyContext(System.currentTimeMillis() + (long)this.configuration.getPruneDelay());
    }

    public EmptyContext doSomeWork(EmptyContext lastContext, GraphDatabaseService database) {
        this.changeWriter.pruneChanges(this.configuration.getMaxChanges(), this.configuration.getPruneWhenMaxExceededBy());
        return new EmptyContext(System.currentTimeMillis() + (long)this.configuration.getPruneDelay());
    }
}

