/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.changefeed;

import com.graphaware.common.policy.InclusionPolicies;
import com.graphaware.runtime.config.BaseTxDrivenModuleConfiguration;
import com.graphaware.runtime.policy.InclusionPoliciesFactory;

public class ChangeFeedConfiguration
extends BaseTxDrivenModuleConfiguration<ChangeFeedConfiguration> {
    private static final int DEFAULT_MAX_CHANGES = 100;
    private static final int DEFAULT_PRUNE_DELAY = 10000;
    private static final int DEFAULT_PRUNE_WHEN_MAX_EXCEEDED_BY = 10;
    private final int maxChanges;
    private final int pruneDelay;
    private final int pruneWhenMaxExceededBy;

    public static ChangeFeedConfiguration defaultConfiguration() {
        return new ChangeFeedConfiguration(InclusionPoliciesFactory.allBusiness(), 100, 10000, 10);
    }

    protected ChangeFeedConfiguration(InclusionPolicies InclusionPolicies2, int maxChanges, int pruneDelay, int pruneWhenMaxExceededBy) {
        super(InclusionPolicies2);
        this.maxChanges = maxChanges;
        this.pruneDelay = pruneDelay;
        this.pruneWhenMaxExceededBy = pruneWhenMaxExceededBy;
    }

    public int getMaxChanges() {
        return this.maxChanges;
    }

    public int getPruneDelay() {
        return this.pruneDelay;
    }

    public int getPruneWhenMaxExceededBy() {
        return this.pruneWhenMaxExceededBy;
    }

    public ChangeFeedConfiguration withMaxChanges(int maxChanges) {
        return new ChangeFeedConfiguration(this.getInclusionPolicies(), maxChanges, this.getPruneDelay(), this.getPruneWhenMaxExceededBy());
    }

    public ChangeFeedConfiguration withPruneDelay(int pruneDelay) {
        return new ChangeFeedConfiguration(this.getInclusionPolicies(), this.getMaxChanges(), pruneDelay, this.getPruneWhenMaxExceededBy());
    }

    public ChangeFeedConfiguration withPruneWhenMaxExceededBy(int pruneWhenMaxExceededBy) {
        return new ChangeFeedConfiguration(this.getInclusionPolicies(), this.getMaxChanges(), this.pruneDelay, pruneWhenMaxExceededBy);
    }

    protected ChangeFeedConfiguration newInstance(InclusionPolicies inclusionPolicies) {
        return new ChangeFeedConfiguration(inclusionPolicies, this.getMaxChanges(), this.getPruneDelay(), this.getPruneWhenMaxExceededBy());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChangeFeedConfiguration that = (ChangeFeedConfiguration)((Object)o);
        if (this.maxChanges != that.maxChanges) {
            return false;
        }
        if (this.pruneDelay != that.pruneDelay) {
            return false;
        }
        return this.pruneWhenMaxExceededBy == that.pruneWhenMaxExceededBy;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.maxChanges;
        result = 31 * result + this.pruneDelay;
        result = 31 * result + this.pruneWhenMaxExceededBy;
        return result;
    }
}

