/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ComparisonChain;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.SortedSet;
import org.gradle.internal.normalization.java.impl.AnnotationValue;
import org.gradle.internal.normalization.java.impl.Member;

public class AnnotationMember
extends Member
implements Comparable<AnnotationMember> {
    private final SortedSet<AnnotationValue<?>> values = Sets.newTreeSet();
    private final boolean visible;

    public AnnotationMember(String string, boolean bl2) {
        super(string);
        this.visible = bl2;
    }

    public SortedSet<AnnotationValue<?>> getValues() {
        return ImmutableSortedSet.copyOf(this.values);
    }

    public void addValue(AnnotationValue<?> annotationValue) {
        this.values.add(annotationValue);
    }

    public void addValues(Collection<AnnotationValue<?>> collection) {
        this.values.addAll(collection);
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected ComparisonChain compare(AnnotationMember annotationMember) {
        return super.compare(annotationMember).compareFalseFirst(this.visible, annotationMember.visible);
    }

    @Override
    public int compareTo(AnnotationMember annotationMember) {
        return this.compare(annotationMember).result();
    }
}

