/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;

public class IgnoredPathFileSystemLocationFingerprint
implements FileSystemLocationFingerprint {
    public static final IgnoredPathFileSystemLocationFingerprint DIRECTORY = new IgnoredPathFileSystemLocationFingerprint(FileType.Directory, DIR_SIGNATURE);
    private static final IgnoredPathFileSystemLocationFingerprint MISSING_FILE = new IgnoredPathFileSystemLocationFingerprint(FileType.Missing, MISSING_FILE_SIGNATURE);
    private final FileType type;
    private final HashCode normalizedContentHash;

    public static IgnoredPathFileSystemLocationFingerprint create(FileType fileType, HashCode hashCode) {
        switch (fileType) {
            case Directory: {
                return DIRECTORY;
            }
            case Missing: {
                return MISSING_FILE;
            }
            case RegularFile: {
                return new IgnoredPathFileSystemLocationFingerprint(FileType.RegularFile, hashCode);
            }
        }
        throw new IllegalStateException();
    }

    private IgnoredPathFileSystemLocationFingerprint(FileType fileType, HashCode hashCode) {
        this.type = fileType;
        this.normalizedContentHash = hashCode;
    }

    @Override
    public String getNormalizedPath() {
        return "";
    }

    @Override
    public HashCode getNormalizedContentHash() {
        return this.normalizedContentHash;
    }

    public FileType getType() {
        return this.type;
    }

    @Override
    public int compareTo(FileSystemLocationFingerprint fileSystemLocationFingerprint) {
        if (!(fileSystemLocationFingerprint instanceof IgnoredPathFileSystemLocationFingerprint)) {
            return -1;
        }
        return this.normalizedContentHash.compareTo(fileSystemLocationFingerprint.getNormalizedContentHash());
    }

    @Override
    public void appendToHasher(Hasher hasher) {
        hasher.putHash(this.normalizedContentHash);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IgnoredPathFileSystemLocationFingerprint ignoredPathFileSystemLocationFingerprint = (IgnoredPathFileSystemLocationFingerprint)object;
        return this.normalizedContentHash.equals(ignoredPathFileSystemLocationFingerprint.normalizedContentHash);
    }

    public int hashCode() {
        return this.normalizedContentHash.hashCode();
    }

    public String toString() {
        return String.format("IGNORED / %s", this.getType() == FileType.Directory ? "DIR" : (this.getType() == FileType.Missing ? "MISSING" : this.normalizedContentHash));
    }
}

