/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.LifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSession;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSessionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionTracker
extends AbstractLifeCycle
implements Dumpable,
WebSocketSessionListener {
    private final Set<WebSocketSession> sessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public Set<WebSocketSession> getSessions() {
        return Collections.unmodifiableSet(new HashSet<WebSocketSession>(this.sessions));
    }

    @Override
    public void onSessionCreated(WebSocketSession webSocketSession) {
        LifeCycle.start(webSocketSession);
        this.sessions.add(webSocketSession);
    }

    @Override
    public void onSessionClosed(WebSocketSession webSocketSession) {
        this.sessions.remove(webSocketSession);
        LifeCycle.stop(webSocketSession);
    }

    @Override
    protected void doStop() throws Exception {
        for (WebSocketSession webSocketSession : this.sessions) {
            LifeCycle.stop(webSocketSession);
        }
        super.doStop();
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Dumpable.dumpObjects(appendable, string, this, this.sessions);
    }
}

