/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.util.Properties;

public abstract class AbstractLogger
implements Logger {
    public static final int LEVEL_DEFAULT = -1;
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARN = 3;
    public static final int LEVEL_OFF = 10;

    @Override
    public final Logger getLogger(String string) {
        if (AbstractLogger.isBlank(string)) {
            return this;
        }
        String string2 = this.getName();
        String string3 = AbstractLogger.isBlank(string2) || Log.getRootLogger() == this ? string : string2 + "." + string;
        Logger logger = Log.getLoggers().get(string3);
        if (logger == null) {
            Logger logger2 = this.newLogger(string3);
            logger = Log.getMutableLoggers().putIfAbsent(string3, logger2);
            if (logger == null) {
                logger = logger2;
            }
        }
        return logger;
    }

    protected abstract Logger newLogger(String var1);

    private static boolean isBlank(String string) {
        if (string == null) {
            return true;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            return false;
        }
        return true;
    }

    public static int lookupLoggingLevel(Properties properties, String string) {
        if (properties == null || properties.isEmpty() || string == null) {
            return -1;
        }
        String string2 = string;
        while (string2 != null && string2.length() > 0) {
            String string3 = properties.getProperty(string2 + ".LEVEL");
            int n2 = AbstractLogger.getLevelId(string2 + ".LEVEL", string3);
            if (n2 != -1) {
                return n2;
            }
            int n3 = string2.lastIndexOf(46);
            if (n3 >= 0) {
                string2 = string2.substring(0, n3);
                continue;
            }
            string2 = null;
        }
        return -1;
    }

    public static String getLoggingProperty(Properties properties, String string, String string2) {
        String string3 = string;
        while (string3 != null && string3.length() > 0) {
            String string4 = properties.getProperty(string3 + "." + string2);
            if (string4 != null) {
                return string4;
            }
            int n2 = string3.lastIndexOf(46);
            string3 = n2 >= 0 ? string3.substring(0, n2) : null;
        }
        return null;
    }

    protected static int getLevelId(String string, String string2) {
        if (string2 == null) {
            return -1;
        }
        String string3 = string2.trim();
        if ("ALL".equalsIgnoreCase(string3)) {
            return 0;
        }
        if ("DEBUG".equalsIgnoreCase(string3)) {
            return 1;
        }
        if ("INFO".equalsIgnoreCase(string3)) {
            return 2;
        }
        if ("WARN".equalsIgnoreCase(string3)) {
            return 3;
        }
        if ("OFF".equalsIgnoreCase(string3)) {
            return 10;
        }
        System.err.println("Unknown StdErrLog level [" + string + "]=[" + string3 + "], expecting only [ALL, DEBUG, INFO, WARN, OFF] as values.");
        return -1;
    }

    protected static String condensePackageString(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = -1;
        int n4 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (!bl2 && (bl2 = Character.isJavaIdentifierStart(c2))) {
                if (n3 >= 0) {
                    stringBuilder.append(string.charAt(n3));
                    bl3 = true;
                }
                n3 = i2;
            }
            if (!bl2) continue;
            if (!Character.isJavaIdentifierPart(c2)) {
                bl2 = false;
                continue;
            }
            n4 = i2;
        }
        if (n3 >= 0 && n4 >= n3) {
            if (bl3) {
                stringBuilder.append('.');
            }
            stringBuilder.append(string, n3, n4 + 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public void debug(String string, long l2) {
        if (this.isDebugEnabled()) {
            this.debug(string, new Object[]{new Long(l2)});
        }
    }
}

