/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Uptime;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.LifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractLifeCycle
implements LifeCycle {
    private static final Logger LOG = Log.getLogger(AbstractLifeCycle.class);
    private final CopyOnWriteArrayList<LifeCycle.Listener> _listeners = new CopyOnWriteArrayList();
    private final Object _lock = new Object();
    private volatile int _state = 0;
    private long _stopTimeout = 30000L;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (this._state == 2 || this._state == 1) {
                    return;
                }
                this.setStarting();
                this.doStart();
                this.setStarted();
            }
            catch (Throwable throwable) {
                this.setFailed(throwable);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (this._state == 3 || this._state == 0) {
                    return;
                }
                this.setStopping();
                this.doStop();
                this.setStopped();
            }
            catch (Throwable throwable) {
                this.setFailed(throwable);
                throw throwable;
            }
        }
    }

    @Override
    public boolean isRunning() {
        int n2 = this._state;
        return n2 == 2 || n2 == 1;
    }

    @Override
    public boolean isStarted() {
        return this._state == 2;
    }

    @Override
    public boolean isStarting() {
        return this._state == 1;
    }

    @Override
    public boolean isStopping() {
        return this._state == 3;
    }

    @Override
    public boolean isStopped() {
        return this._state == 0;
    }

    @Override
    public boolean isFailed() {
        return this._state == -1;
    }

    public String getState() {
        switch (this._state) {
            case -1: {
                return "FAILED";
            }
            case 1: {
                return "STARTING";
            }
            case 2: {
                return "STARTED";
            }
            case 3: {
                return "STOPPING";
            }
            case 0: {
                return "STOPPED";
            }
        }
        return null;
    }

    public static String getState(LifeCycle lifeCycle) {
        if (lifeCycle.isStarting()) {
            return "STARTING";
        }
        if (lifeCycle.isStarted()) {
            return "STARTED";
        }
        if (lifeCycle.isStopping()) {
            return "STOPPING";
        }
        if (lifeCycle.isStopped()) {
            return "STOPPED";
        }
        return "FAILED";
    }

    private void setStarted() {
        this._state = 2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("STARTED @{}ms {}", Uptime.getUptime(), this);
        }
        for (LifeCycle.Listener listener : this._listeners) {
            listener.lifeCycleStarted(this);
        }
    }

    private void setStarting() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting {}", this);
        }
        this._state = 1;
        for (LifeCycle.Listener listener : this._listeners) {
            listener.lifeCycleStarting(this);
        }
    }

    private void setStopping() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("stopping {}", this);
        }
        this._state = 3;
        for (LifeCycle.Listener listener : this._listeners) {
            listener.lifeCycleStopping(this);
        }
    }

    private void setStopped() {
        this._state = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {}", "STOPPED", this);
        }
        for (LifeCycle.Listener listener : this._listeners) {
            listener.lifeCycleStopped(this);
        }
    }

    private void setFailed(Throwable throwable) {
        this._state = -1;
        if (LOG.isDebugEnabled()) {
            LOG.warn("FAILED " + this + ": " + throwable, throwable);
        }
        for (LifeCycle.Listener listener : this._listeners) {
            listener.lifeCycleFailure(this, throwable);
        }
    }

    public long getStopTimeout() {
        return this._stopTimeout;
    }

    public void setStopTimeout(long l2) {
        this._stopTimeout = l2;
    }

    public String toString() {
        String string = this.getClass().getSimpleName();
        if (StringUtil.isBlank(string) && this.getClass().getSuperclass() != null) {
            string = this.getClass().getSuperclass().getSimpleName();
        }
        return String.format("%s@%x{%s}", string, this.hashCode(), this.getState());
    }
}

