/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StdDateFormat
extends DateFormat {
    protected static final Pattern PATTERN_PLAIN = Pattern.compile("\\d\\d\\d\\d[-]\\d\\d[-]\\d\\d");
    protected static final Pattern PATTERN_ISO8601;
    protected static final String[] ALL_FORMATS;
    protected static final TimeZone DEFAULT_TIMEZONE;
    protected static final Locale DEFAULT_LOCALE;
    protected static final DateFormat DATE_FORMAT_RFC1123;
    public static final StdDateFormat instance;
    protected static final Calendar CALENDAR;
    protected transient TimeZone _timezone;
    protected final Locale _locale;
    protected Boolean _lenient;
    private transient Calendar _calendar;
    private transient DateFormat _formatRFC1123;
    private boolean _tzSerializedWithColon = true;

    public StdDateFormat() {
        this._locale = DEFAULT_LOCALE;
    }

    protected StdDateFormat(TimeZone timeZone, Locale locale, Boolean bl2, boolean bl3) {
        this._timezone = timeZone;
        this._locale = locale;
        this._lenient = bl2;
        this._tzSerializedWithColon = bl3;
    }

    public StdDateFormat withTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = DEFAULT_TIMEZONE;
        }
        if (timeZone == this._timezone || timeZone.equals(this._timezone)) {
            return this;
        }
        return new StdDateFormat(timeZone, this._locale, this._lenient, this._tzSerializedWithColon);
    }

    public StdDateFormat withLocale(Locale locale) {
        if (locale.equals(this._locale)) {
            return this;
        }
        return new StdDateFormat(this._timezone, locale, this._lenient, this._tzSerializedWithColon);
    }

    public StdDateFormat withLenient(Boolean bl2) {
        if (StdDateFormat._equals(bl2, this._lenient)) {
            return this;
        }
        return new StdDateFormat(this._timezone, this._locale, bl2, this._tzSerializedWithColon);
    }

    @Override
    public StdDateFormat clone() {
        return new StdDateFormat(this._timezone, this._locale, this._lenient, this._tzSerializedWithColon);
    }

    @Override
    public TimeZone getTimeZone() {
        return this._timezone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (!timeZone.equals(this._timezone)) {
            this._clearFormats();
            this._timezone = timeZone;
        }
    }

    @Override
    public void setLenient(boolean bl2) {
        Boolean bl3 = bl2;
        if (!StdDateFormat._equals(bl3, this._lenient)) {
            this._lenient = bl3;
            this._clearFormats();
        }
    }

    @Override
    public boolean isLenient() {
        return this._lenient == null || this._lenient != false;
    }

    @Override
    public Date parse(String string) throws ParseException {
        ParsePosition parsePosition;
        Date date = this._parseDate(string = string.trim(), parsePosition = new ParsePosition(0));
        if (date != null) {
            return date;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : ALL_FORMATS) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\", \"");
            } else {
                stringBuilder.append('\"');
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append('\"');
        throw new ParseException(String.format("Cannot parse date \"%s\": not compatible with any of standard forms (%s)", string, stringBuilder.toString()), parsePosition.getErrorIndex());
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        try {
            return this._parseDate(string, parsePosition);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    protected Date _parseDate(String string, ParsePosition parsePosition) throws ParseException {
        char c2;
        if (this.looksLikeISO8601(string)) {
            return this.parseAsISO8601(string, parsePosition);
        }
        int n2 = string.length();
        while (--n2 >= 0 && ((c2 = string.charAt(n2)) >= '0' && c2 <= '9' || n2 <= 0 && c2 == '-')) {
        }
        if (n2 < 0 && (string.charAt(0) == '-' || NumberInput.inLongRange(string, false))) {
            return this._parseDateFromLong(string, parsePosition);
        }
        return this.parseAsRFC1123(string, parsePosition);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        TimeZone timeZone = this._timezone;
        if (timeZone == null) {
            timeZone = DEFAULT_TIMEZONE;
        }
        this._format(timeZone, this._locale, date, stringBuffer);
        return stringBuffer;
    }

    protected void _format(TimeZone timeZone, Locale locale, Date date, StringBuffer stringBuffer) {
        Calendar calendar = this._getCalendar(timeZone);
        calendar.setTime(date);
        int n2 = calendar.get(1);
        if (calendar.get(0) == 0) {
            this._formatBCEYear(stringBuffer, n2);
        } else {
            if (n2 > 9999) {
                stringBuffer.append('+');
            }
            StdDateFormat.pad4(stringBuffer, n2);
        }
        stringBuffer.append('-');
        StdDateFormat.pad2(stringBuffer, calendar.get(2) + 1);
        stringBuffer.append('-');
        StdDateFormat.pad2(stringBuffer, calendar.get(5));
        stringBuffer.append('T');
        StdDateFormat.pad2(stringBuffer, calendar.get(11));
        stringBuffer.append(':');
        StdDateFormat.pad2(stringBuffer, calendar.get(12));
        stringBuffer.append(':');
        StdDateFormat.pad2(stringBuffer, calendar.get(13));
        stringBuffer.append('.');
        StdDateFormat.pad3(stringBuffer, calendar.get(14));
        int n3 = timeZone.getOffset(calendar.getTimeInMillis());
        if (n3 != 0) {
            int n4 = Math.abs(n3 / 60000 / 60);
            int n5 = Math.abs(n3 / 60000 % 60);
            stringBuffer.append(n3 < 0 ? (char)'-' : '+');
            StdDateFormat.pad2(stringBuffer, n4);
            if (this._tzSerializedWithColon) {
                stringBuffer.append(':');
            }
            StdDateFormat.pad2(stringBuffer, n5);
        } else if (this._tzSerializedWithColon) {
            stringBuffer.append("+00:00");
        } else {
            stringBuffer.append("+0000");
        }
    }

    protected void _formatBCEYear(StringBuffer stringBuffer, int n2) {
        if (n2 == 1) {
            stringBuffer.append("+0000");
            return;
        }
        int n3 = n2 - 1;
        stringBuffer.append('-');
        StdDateFormat.pad4(stringBuffer, n3);
    }

    private static void pad2(StringBuffer stringBuffer, int n2) {
        int n3 = n2 / 10;
        if (n3 == 0) {
            stringBuffer.append('0');
        } else {
            stringBuffer.append((char)(48 + n3));
            n2 -= 10 * n3;
        }
        stringBuffer.append((char)(48 + n2));
    }

    private static void pad3(StringBuffer stringBuffer, int n2) {
        int n3 = n2 / 100;
        if (n3 == 0) {
            stringBuffer.append('0');
        } else {
            stringBuffer.append((char)(48 + n3));
            n2 -= n3 * 100;
        }
        StdDateFormat.pad2(stringBuffer, n2);
    }

    private static void pad4(StringBuffer stringBuffer, int n2) {
        int n3 = n2 / 100;
        if (n3 == 0) {
            stringBuffer.append('0').append('0');
        } else {
            if (n3 > 99) {
                stringBuffer.append(n3);
            } else {
                StdDateFormat.pad2(stringBuffer, n3);
            }
            n2 -= 100 * n3;
        }
        StdDateFormat.pad2(stringBuffer, n2);
    }

    public String toString() {
        return String.format("DateFormat %s: (timezone: %s, locale: %s, lenient: %s)", this.getClass().getName(), this._timezone, this._locale, this._lenient);
    }

    public String toPattern() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("[one of: '").append("yyyy-MM-dd'T'HH:mm:ss.SSSX").append("', '").append("EEE, dd MMM yyyy HH:mm:ss zzz").append("' (");
        stringBuilder.append(Boolean.FALSE.equals(this._lenient) ? "strict" : "lenient").append(")]");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    protected boolean looksLikeISO8601(String string) {
        return string.length() >= 7 && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(3)) && string.charAt(4) == '-' && Character.isDigit(string.charAt(5));
    }

    private Date _parseDateFromLong(String string, ParsePosition parsePosition) throws ParseException {
        long l2;
        try {
            l2 = NumberInput.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(String.format("Timestamp value %s out of 64-bit value range", string), parsePosition.getErrorIndex());
        }
        return new Date(l2);
    }

    protected Date parseAsISO8601(String string, ParsePosition parsePosition) throws ParseException {
        try {
            return this._parseAsISO8601(string, parsePosition);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(String.format("Cannot parse date \"%s\", problem: %s", string, illegalArgumentException.getMessage()), parsePosition.getErrorIndex());
        }
    }

    protected Date _parseAsISO8601(String string, ParsePosition parsePosition) throws IllegalArgumentException, ParseException {
        String string2;
        int n2 = string.length();
        TimeZone timeZone = DEFAULT_TIMEZONE;
        if (this._timezone != null && 'Z' != string.charAt(n2 - 1)) {
            timeZone = this._timezone;
        }
        Calendar calendar = this._getCalendar(timeZone);
        calendar.clear();
        if (n2 <= 10) {
            Matcher matcher = PATTERN_PLAIN.matcher(string);
            if (matcher.matches()) {
                int n3 = StdDateFormat._parse4D(string, 0);
                int n4 = StdDateFormat._parse2D(string, 5) - 1;
                int n5 = StdDateFormat._parse2D(string, 8);
                calendar.set(n3, n4, n5, 0, 0, 0);
                calendar.set(14, 0);
                return calendar.getTime();
            }
            string2 = "yyyy-MM-dd";
        } else {
            Matcher matcher = PATTERN_ISO8601.matcher(string);
            if (matcher.matches()) {
                int n6;
                int n7 = matcher.start(2);
                int n8 = matcher.end(2);
                int n9 = n8 - n7;
                if (n9 > 1) {
                    n6 = StdDateFormat._parse2D(string, n7 + 1) * 3600;
                    if (n9 >= 5) {
                        n6 += StdDateFormat._parse2D(string, n8 - 2) * 60;
                    }
                    n6 = string.charAt(n7) == '-' ? (n6 *= -1000) : (n6 *= 1000);
                    calendar.set(15, n6);
                    calendar.set(16, 0);
                }
                n6 = StdDateFormat._parse4D(string, 0);
                int n10 = StdDateFormat._parse2D(string, 5) - 1;
                int n11 = StdDateFormat._parse2D(string, 8);
                int n12 = StdDateFormat._parse2D(string, 11);
                int n13 = StdDateFormat._parse2D(string, 14);
                int n14 = n2 > 16 && string.charAt(16) == ':' ? StdDateFormat._parse2D(string, 17) : 0;
                calendar.set(n6, n10, n11, n12, n13, n14);
                n7 = matcher.start(1) + 1;
                n8 = matcher.end(1);
                int n15 = 0;
                if (n7 >= n8) {
                    calendar.set(14, 0);
                } else {
                    n15 = 0;
                    int n16 = n8 - n7;
                    switch (n16) {
                        default: {
                            if (n16 > 9) {
                                throw new ParseException(String.format("Cannot parse date \"%s\": invalid fractional seconds '%s'; can use at most 9 digits", string, matcher.group(1).substring(1)), n7);
                            }
                        }
                        case 3: {
                            n15 += string.charAt(n7 + 2) - 48;
                        }
                        case 2: {
                            n15 += 10 * (string.charAt(n7 + 1) - 48);
                        }
                        case 1: {
                            n15 += 100 * (string.charAt(n7) - 48);
                        }
                        case 0: 
                    }
                    calendar.set(14, n15);
                }
                return calendar.getTime();
            }
            string2 = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
        }
        throw new ParseException(String.format("Cannot parse date \"%s\": while it seems to fit format '%s', parsing fails (leniency? %s)", string, string2, this._lenient), 0);
    }

    private static int _parse4D(String string, int n2) {
        return 1000 * (string.charAt(n2) - 48) + 100 * (string.charAt(n2 + 1) - 48) + 10 * (string.charAt(n2 + 2) - 48) + (string.charAt(n2 + 3) - 48);
    }

    private static int _parse2D(String string, int n2) {
        return 10 * (string.charAt(n2) - 48) + (string.charAt(n2 + 1) - 48);
    }

    protected Date parseAsRFC1123(String string, ParsePosition parsePosition) {
        if (this._formatRFC1123 == null) {
            this._formatRFC1123 = StdDateFormat._cloneFormat(DATE_FORMAT_RFC1123, "EEE, dd MMM yyyy HH:mm:ss zzz", this._timezone, this._locale, this._lenient);
        }
        return this._formatRFC1123.parse(string, parsePosition);
    }

    private static final DateFormat _cloneFormat(DateFormat dateFormat, String string, TimeZone timeZone, Locale locale, Boolean bl2) {
        if (!locale.equals(DEFAULT_LOCALE)) {
            dateFormat = new SimpleDateFormat(string, locale);
            dateFormat.setTimeZone(timeZone == null ? DEFAULT_TIMEZONE : timeZone);
        } else {
            dateFormat = (DateFormat)dateFormat.clone();
            if (timeZone != null) {
                dateFormat.setTimeZone(timeZone);
            }
        }
        if (bl2 != null) {
            dateFormat.setLenient(bl2);
        }
        return dateFormat;
    }

    protected void _clearFormats() {
        this._formatRFC1123 = null;
    }

    protected Calendar _getCalendar(TimeZone timeZone) {
        Calendar calendar = this._calendar;
        if (calendar == null) {
            this._calendar = calendar = (Calendar)CALENDAR.clone();
        }
        if (!calendar.getTimeZone().equals(timeZone)) {
            calendar.setTimeZone(timeZone);
        }
        calendar.setLenient(this.isLenient());
        return calendar;
    }

    protected static <T> boolean _equals(T t2, T t3) {
        if (t2 == t3) {
            return true;
        }
        return t2 != null && t2.equals(t3);
    }

    static {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile("\\d\\d\\d\\d[-]\\d\\d[-]\\d\\d[T]\\d\\d[:]\\d\\d(?:[:]\\d\\d)?(\\.\\d+)?(Z|[+-]\\d\\d(?:[:]?\\d\\d)?)?");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        PATTERN_ISO8601 = pattern;
        ALL_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd'T'HH:mm:ss.SSS", "EEE, dd MMM yyyy HH:mm:ss zzz", "yyyy-MM-dd"};
        DEFAULT_TIMEZONE = TimeZone.getTimeZone("UTC");
        DEFAULT_LOCALE = Locale.US;
        DATE_FORMAT_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", DEFAULT_LOCALE);
        DATE_FORMAT_RFC1123.setTimeZone(DEFAULT_TIMEZONE);
        instance = new StdDateFormat();
        CALENDAR = new GregorianCalendar(DEFAULT_TIMEZONE, DEFAULT_LOCALE);
    }
}

