/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyMetadata;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public abstract class ConcreteBeanPropertyBase
implements BeanProperty,
Serializable {
    protected final PropertyMetadata _metadata;
    protected transient List<PropertyName> _aliases;

    protected ConcreteBeanPropertyBase(PropertyMetadata propertyMetadata) {
        this._metadata = propertyMetadata == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : propertyMetadata;
    }

    protected ConcreteBeanPropertyBase(ConcreteBeanPropertyBase concreteBeanPropertyBase) {
        this._metadata = concreteBeanPropertyBase._metadata;
    }

    public boolean isRequired() {
        return this._metadata.isRequired();
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public JsonFormat.Value findPropertyFormat(MapperConfig<?> mapperConfig, Class<?> clazz) {
        AnnotatedMember annotatedMember;
        JsonFormat.Value value = mapperConfig.getDefaultPropertyFormat(clazz);
        JsonFormat.Value value2 = null;
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        if (annotationIntrospector != null && (annotatedMember = this.getMember()) != null) {
            value2 = annotationIntrospector.findFormat(annotatedMember);
        }
        if (value == null) {
            return value2 == null ? EMPTY_FORMAT : value2;
        }
        return value2 == null ? value : value.withOverrides(value2);
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> mapperConfig, Class<?> clazz) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        AnnotatedMember annotatedMember = this.getMember();
        if (annotatedMember == null) {
            JsonInclude.Value value = mapperConfig.getDefaultPropertyInclusion(clazz);
            return value;
        }
        JsonInclude.Value value = mapperConfig.getDefaultInclusion(clazz, annotatedMember.getRawType());
        if (annotationIntrospector == null) {
            return value;
        }
        JsonInclude.Value value2 = annotationIntrospector.findPropertyInclusion(annotatedMember);
        if (value == null) {
            return value2;
        }
        return value.withOverrides(value2);
    }

    public List<PropertyName> findAliases(MapperConfig<?> mapperConfig) {
        List<PropertyName> list = this._aliases;
        if (list == null) {
            AnnotatedMember annotatedMember;
            AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
            if (annotationIntrospector != null && (annotatedMember = this.getMember()) != null) {
                list = annotationIntrospector.findPropertyAliases(annotatedMember);
            }
            if (list == null) {
                list = Collections.emptyList();
            }
            this._aliases = list;
        }
        return list;
    }
}

