/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonEncoding;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamReadConstraints;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.TokenStreamFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.CharacterEscapes;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.ContentReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.InputDecorator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.OutputDecorator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.UTF8Writer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.json.ByteSourceJsonBootstrapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.json.ReaderBasedJsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.json.UTF8JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.json.WriterBasedJsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.BufferRecycler;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.BufferRecyclers;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.JacksonFeature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;

public class JsonFactory
extends TokenStreamFactory
implements Serializable {
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    public static final SerializableString DEFAULT_ROOT_VALUE_SEPARATOR = DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR;
    protected final transient CharsToNameCanonicalizer _rootCharSymbols = CharsToNameCanonicalizer.createRoot();
    protected final transient ByteQuadsCanonicalizer _byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();
    protected int _factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
    protected int _parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
    protected int _generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
    protected ObjectCodec _objectCodec;
    protected CharacterEscapes _characterEscapes;
    protected StreamReadConstraints _streamReadConstraints;
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;
    protected SerializableString _rootValueSeparator = DEFAULT_ROOT_VALUE_SEPARATOR;
    protected int _maximumNonEscapedChar;
    protected final char _quoteChar;

    public JsonFactory() {
        this(null);
    }

    public JsonFactory(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        this._quoteChar = (char)34;
        this._streamReadConstraints = StreamReadConstraints.defaults();
    }

    public boolean requiresPropertyOrdering() {
        return false;
    }

    public boolean canHandleBinaryNatively() {
        return false;
    }

    public boolean canUseCharArrays() {
        return true;
    }

    public String getFormatName() {
        if (this.getClass() == JsonFactory.class) {
            return "JSON";
        }
        return null;
    }

    public JsonFactory disable(JsonGenerator.Feature feature) {
        this._generatorFeatures &= ~feature.getMask();
        return this;
    }

    public JsonFactory setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public JsonParser createParser(File file) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(this._createContentReference(file), true);
        InputStream inputStream = this._fileInputStream(file);
        return this._createParser(this._decorate(inputStream, iOContext), iOContext);
    }

    public JsonParser createParser(InputStream inputStream) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(this._createContentReference(inputStream), false);
        return this._createParser(this._decorate(inputStream, iOContext), iOContext);
    }

    public JsonParser createParser(Reader reader) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(this._createContentReference(reader), false);
        return this._createParser(this._decorate(reader, iOContext), iOContext);
    }

    public JsonParser createParser(byte[] byArray) throws IOException, JsonParseException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(this._createContentReference(byArray), true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    public JsonParser createParser(String string) throws IOException, JsonParseException {
        int n2 = string.length();
        if (this._inputDecorator != null || n2 > 32768 || !this.canUseCharArrays()) {
            return this.createParser(new StringReader(string));
        }
        IOContext iOContext = this._createContext(this._createContentReference(string), true);
        char[] cArray = iOContext.allocTokenBuffer(n2);
        string.getChars(0, n2, cArray, 0);
        return this._createParser(cArray, 0, n2, iOContext, true);
    }

    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(outputStream), false);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            return this._createUTF8Generator(this._decorate(outputStream, iOContext), iOContext);
        }
        Writer writer = this._createWriter(outputStream, jsonEncoding, iOContext);
        return this._createGenerator(this._decorate(writer, iOContext), iOContext);
    }

    public JsonGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    public JsonGenerator createGenerator(Writer writer) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(writer), false);
        return this._createGenerator(this._decorate(writer, iOContext), iOContext);
    }

    public JsonGenerator createGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        OutputStream outputStream = this._fileOutputStream(file);
        IOContext iOContext = this._createContext(this._createContentReference(outputStream), true);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            return this._createUTF8Generator(this._decorate(outputStream, iOContext), iOContext);
        }
        Writer writer = this._createWriter(outputStream, jsonEncoding, iOContext);
        return this._createGenerator(this._decorate(writer, iOContext), iOContext);
    }

    protected JsonParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException {
        try {
            return new ByteSourceJsonBootstrapper(iOContext, inputStream).constructParser(this._parserFeatures, this._objectCodec, this._byteSymbolCanonicalizer, this._rootCharSymbols, this._factoryFeatures);
        }
        catch (IOException | RuntimeException exception) {
            if (iOContext.isResourceManaged()) {
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {
                    exception.addSuppressed(exception2);
                }
            }
            throw exception;
        }
    }

    protected JsonParser _createParser(Reader reader, IOContext iOContext) throws IOException {
        return new ReaderBasedJsonParser(iOContext, this._parserFeatures, reader, this._objectCodec, this._rootCharSymbols.makeChild(this._factoryFeatures));
    }

    protected JsonParser _createParser(char[] cArray, int n2, int n3, IOContext iOContext, boolean bl2) throws IOException {
        return new ReaderBasedJsonParser(iOContext, this._parserFeatures, null, this._objectCodec, this._rootCharSymbols.makeChild(this._factoryFeatures), cArray, n2, n2 + n3, bl2);
    }

    protected JsonParser _createParser(byte[] byArray, int n2, int n3, IOContext iOContext) throws IOException {
        return new ByteSourceJsonBootstrapper(iOContext, byArray, n2, n3).constructParser(this._parserFeatures, this._objectCodec, this._byteSymbolCanonicalizer, this._rootCharSymbols, this._factoryFeatures);
    }

    protected JsonGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
        SerializableString serializableString;
        WriterBasedJsonGenerator writerBasedJsonGenerator = new WriterBasedJsonGenerator(iOContext, this._generatorFeatures, this._objectCodec, writer, this._quoteChar);
        if (this._maximumNonEscapedChar > 0) {
            writerBasedJsonGenerator.setHighestNonEscapedChar(this._maximumNonEscapedChar);
        }
        if (this._characterEscapes != null) {
            writerBasedJsonGenerator.setCharacterEscapes(this._characterEscapes);
        }
        if ((serializableString = this._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            writerBasedJsonGenerator.setRootValueSeparator(serializableString);
        }
        return writerBasedJsonGenerator;
    }

    protected JsonGenerator _createUTF8Generator(OutputStream outputStream, IOContext iOContext) throws IOException {
        SerializableString serializableString;
        UTF8JsonGenerator uTF8JsonGenerator = new UTF8JsonGenerator(iOContext, this._generatorFeatures, this._objectCodec, outputStream, this._quoteChar);
        if (this._maximumNonEscapedChar > 0) {
            uTF8JsonGenerator.setHighestNonEscapedChar(this._maximumNonEscapedChar);
        }
        if (this._characterEscapes != null) {
            uTF8JsonGenerator.setCharacterEscapes(this._characterEscapes);
        }
        if ((serializableString = this._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            uTF8JsonGenerator.setRootValueSeparator(serializableString);
        }
        return uTF8JsonGenerator;
    }

    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(iOContext, outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected final InputStream _decorate(InputStream inputStream, IOContext iOContext) throws IOException {
        InputStream inputStream2;
        if (this._inputDecorator != null && (inputStream2 = this._inputDecorator.decorate(iOContext, inputStream)) != null) {
            return inputStream2;
        }
        return inputStream;
    }

    protected final Reader _decorate(Reader reader, IOContext iOContext) throws IOException {
        Reader reader2;
        if (this._inputDecorator != null && (reader2 = this._inputDecorator.decorate(iOContext, reader)) != null) {
            return reader2;
        }
        return reader;
    }

    protected final OutputStream _decorate(OutputStream outputStream, IOContext iOContext) throws IOException {
        OutputStream outputStream2;
        if (this._outputDecorator != null && (outputStream2 = this._outputDecorator.decorate(iOContext, outputStream)) != null) {
            return outputStream2;
        }
        return outputStream;
    }

    protected final Writer _decorate(Writer writer, IOContext iOContext) throws IOException {
        Writer writer2;
        if (this._outputDecorator != null && (writer2 = this._outputDecorator.decorate(iOContext, writer)) != null) {
            return writer2;
        }
        return writer;
    }

    public BufferRecycler _getBufferRecycler() {
        if (Feature.USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING.enabledIn(this._factoryFeatures)) {
            return BufferRecyclers.getBufferRecycler();
        }
        return new BufferRecycler();
    }

    protected IOContext _createContext(ContentReference contentReference, boolean bl2) {
        if (contentReference == null) {
            contentReference = ContentReference.unknown();
        }
        return new IOContext(this._streamReadConstraints, this._getBufferRecycler(), contentReference, bl2);
    }

    protected ContentReference _createContentReference(Object object) {
        return ContentReference.construct(!this.canHandleBinaryNatively(), object);
    }

    protected ContentReference _createContentReference(Object object, int n2, int n3) {
        return ContentReference.construct(!this.canHandleBinaryNatively(), object, n2, n3);
    }

    public static enum Feature implements JacksonFeature
    {
        INTERN_FIELD_NAMES(true),
        CANONICALIZE_FIELD_NAMES(true),
        FAIL_ON_SYMBOL_HASH_OVERFLOW(true),
        USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING(true),
        CHARSET_DETECTION(true);

        private final boolean _defaultState;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl2) {
            this._defaultState = bl2;
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public boolean enabledIn(int n2) {
            return (n2 & this.getMask()) != 0;
        }

        @Override
        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

